#!/bin/bash
#PBS -N apcp_apcp_ensmean
#PBS -A your_account
#PBS -q dev
#PBS -j oe
#PBS -l select=1:ncpus=1:mem=4GB
#PBS -l walltime=00:20:00
#PBS -J 0-80

module load wgrib2

###############################################################################
# Map array index (0–80) to forecast hours (000–240 every 3h)
###############################################################################
# FH = ARRAY_INDEX * 3
IDX=${PBS_ARRAY_INDEX}
FH=$(printf "%03d" $(( IDX * 3 )))

###############################################################################
# User configuration
###############################################################################
CDATE=20251211
CYC=00

BASE=/lfs/h1/ops/prod/com/gefs/v12.3/gefs.${CDATE}/${CYC}/atmos/pgrb2bp5
OUTDIR=/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/gefs_meteogram/test_dir/ensmean_apcp

mkdir -p $OUTDIR

echo "---------------------------------------------------------"
echo "GEFS APCP 30-member ensemble mean"
echo "Forecast hour F${FH}  (array index ${IDX})"
echo "---------------------------------------------------------"

ACC=acc_f${FH}.grb2

###############################################################################
# 1. Initialize accumulator with member 01
###############################################################################
wgrib2 ${BASE}/gep01.t${CYC}z.pgrb2b.0p50.f${FH} \
    -match "APCP" -grib $ACC

###############################################################################
# 2. Add members 02–30 to accumulator
###############################################################################
for M in $(seq -w 02 30); do
    MEMFILE=${BASE}/gep${M}.t${CYC}z.pgrb2b.0p50.f${FH}
    TMP=tmp_add_${FH}.grb2

    wgrib2 $ACC -match "APCP" \
        -import_grib $MEMFILE -match "APCP" \
        -rpn "sto_1 +rcl_1" -set_grib_type same \
        -grib $TMP

    mv $TMP $ACC
done

###############################################################################
# 3. Divide by 30 → ensemble mean
###############################################################################
OUTFILE=${OUTDIR}/gefs.t${CYC}z.apcp_ensmean.f${FH}.grib2

wgrib2 $ACC -match "APCP" \
    -rpn "30 /" -set_grib_type same \
    -grib $OUTFILE

rm -f $ACC

echo "DONE: $OUTFILE"
echo "---------------------------------------------------------"
✅ 2. Submit the array job
bash
Copy code
qsub apcp_mean_array.pbs
