#!/bin/bash

CDATE=20251211
CYC=00
BASE=/lfs/h1/ops/prod/com/gefs/v12.3/gefs.${CDATE}/${CYC}/atmos/pgrb2bp5

OUTDIR=./ensmean_apcp
mkdir -p $OUTDIR

for FH in $(seq -w 0 3 240); do   # GEFS gives 3-hrly to 240
    echo "Processing F${FH}"

    # Temporary list file
    LIST=files_f${FH}.txt
    > $LIST

    # Collect all 30 member files
    for M in $(seq -w 1 30); do
        echo "${BASE}/gep${M}.t${CYC}z.pgrb2b.0p50.f${FH}" >> $LIST
    done

    # Output ensemble-mean file
    OUTFILE=${OUTDIR}/gefs.t${CYC}z.apcp_ensmean.f${FH}.grib2

    # Compute mean using wgrib2's ens_processing
    # Restrict to APCP only
    wgrib2 $(head -1 $LIST) -match "APCP" -ens_mean $OUTFILE -ens_files $LIST
done

