#!/bin/bash
#
export cyc=$1
export today=`date  --date='0 days ago' '+%Y%m%d'`
export dt=$today$cyc
#
src_dir=/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/gefs_meteogram
work_dir=/lfs/h2/cpc/ptmp/vadlamani.kumar/gefs/$cyc/DIR_stn1
mkdir -p $work_dir
rm $work_dir/*
cd $work_dir
#
cp $src_dir/meteogram_GDS.gs .
cp $src_dir/meteogram_subset_GDS.gs .
#---------------------------------------------------------------------
ln=25.92
lt=-24.22
sed "s/station/Gabarone_Botswana/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/$cyc/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
