#!/bin/bash
#
export cyc=$1
export today=`date  --date='0 days ago' '+%Y%m%d'`
export dt=$today$cyc
#
src_dir=/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/gfs_meteogram
work_dir=/lfs/h2/cpc/ptmp/vadlamani.kumar/gfs/$cyc/DIR_stn5
mkdir -p $work_dir
rm $work_dir/*
cd $work_dir
#
cp $src_dir/meteogram_GDS.gs .
cp $src_dir/meteogram_subset_GDS.gs .
#---------------------------------------------------------------------
#
ln=40.30
lt=-10.58
sed "s/station/Mtwara_Tanzania/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=39.20
lt=-6.87
sed "s/station/Dar_Es_Salaam_Tanzania/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=37.1
lt=-3.4
sed "s/station/Kilimanjaro_Tanzania/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=1.25
lt=6.17
sed "s/station/Lomeae_Togo/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=32.6
lt=0.32
sed "s/station/Kampala_Uganda/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=31.72
lt=1.68
sed "s/station/Masindi_Uganda/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=39.20
lt=-6.8
sed "s/station/Lusaka_Zambia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=31.1
lt=-17.92
sed "s/station/Harare_Zimbabwe/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=29.62
lt=-20.17
sed "s/station/Bulawayo_Zimbabwe/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#--------------------------------------------------------------------
scp $work_dir/*.png vkumar@cpcrzdm:"../www/htdocs/products/international/gfs_meteograms/$cyc/."
