#!/bin/bash 
#
export cyc=$1
export today=`date  --date='0 days ago' '+%Y%m%d'`
export dt=$today$cyc
#
src_dir=/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/gfs_meteogram
work_dir=/lfs/h2/cpc/ptmp/vadlamani.kumar/gfs/$cyc/DIR_stn4
mkdir -p $work_dir
rm $work_dir/*
cd $work_dir
#
cp $src_dir/meteogram_GDS.gs .
cp $src_dir/meteogram_subset_GDS.gs .
#---------------------------------------------------------------------
#
ln=32.56
lt=-25.92
sed "s/station/Maputo_Mozambique/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=34.88
lt=-19.80
sed "s/station/Beria_Mozambique/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=2.2
lt=13.5
sed "s/station/Niamey_Niger/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=3.3
lt=6.6
sed "s/station/Lagos_Nigeria/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=30.14
lt=-1.97
sed "s/station/Kigali_Rwanda/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=29.75
lt=-2.72
sed "s/station/Kansi_Paroiosse_Rwanda/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=-17.5
lt=14.05
sed "s/station/Dakar_Yoff_Senegal/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=31.36
lt=4.52
sed "s/station/Juba_South_Sudan/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=31.39
lt=9.33
sed "s/station/Malakal_South_Sudan/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=31.3
lt=-26.5
sed "s/station/Manzini_Swaziland/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
#-------------------------------------------------------------
scp $work_dir/*.png vkumar@cpcrzdm:"../www/htdocs/products/international/gfs_meteograms/$cyc/."
