#!/bin/bash -l
#
export cyc=$1
export today=`date  --date='0 days ago' '+%Y%m%d'`
export dt=$today$cyc
#
src_dir=/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/meteogram
work_dir=/lfs/h2/cpc/ptmp/vadlamani.kumar/gfs/$cyc/DIR_stn6
mkdir -p $work_dir
rm $work_dir/*
cd $work_dir
#
cp $src_dir/meteogram_GDS.gs .
cp $src_dir/meteogram_subset_GDS.gs .
#---------------------------------------------------------------------
#
ln=39.47
lt=13.52
sed "s/station/Mekele_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=37.24
lt=11.36
sed "s/station/Bahir_Dar_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=38.47
lt=7.06
sed "s/station/Hwassa_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#---------------------------------------------------------------------
#
ln=42.10
lt=9.31
sed "s/station/Harar_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=42.79
lt=9.35
sed "s/station/Jigjiga_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=34.52
lt=10.07
sed "s/station/Assosa_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=34.58
lt=8.25
sed "s/station/Gambella_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=41.00
lt=11.75
sed "s/station/Semera_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=41.85
lt=9.60
sed "s/station/Diredawa_Ethiopia/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#--------------------------------------------------------------------
scp $work_dir/*.png vkumar@cpcrzdm:"../www/htdocs/products/international/gfs_meteograms/$cyc/."
