#!/bin/bash -l
#
export cyc=$1
export today=`date  --date='0 days ago' '+%Y%m%d'`
export dt=$today$cyc
#
src_dir=/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/meteogram
work_dir=/lfs/h2/cpc/ptmp/vadlamani.kumar/gfs/$cyc/DIR_stn3
mkdir -p $work_dir
rm $work_dir/*
cd $work_dir
#
cp $src_dir/meteogram_GDS.gs .
cp $src_dir/meteogram_subset_GDS.gs .
#---------------------------------------------------------------------
#
ln=39.6
lt=-4.0
sed "s/station/Mombasa_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=37.7
lt=0.1
sed "s/station/Meru_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=35.9
lt=-1.1
sed "s/station/Narok_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=40.9
lt=-2.3
sed "s/station/Lamu_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=27.5
lt=-29.5
sed "s/station/Maseru_Mia_Lesotho/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=47.53
lt=-18.9
sed "s/station/Antananarivo_Madagascar/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=47.83
lt=-22.75
sed "s/station/Antsiranana_Madagascar/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=33.8
lt=-13.8
sed "s/station/Lilongwe_Malawi/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=-7.9
lt=12.5
sed "s/station/Bamako_Mali/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=-15.9
lt=18.1
sed "s/station/Nouakchott_Mauritania/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
#--------------------------------------------------------------------
scp $work_dir/*.png vkumar@cpcrzdm:"../www/htdocs/products/international/gfs_meteograms/$cyc/."
