#!/bin/bash -l
#
export cyc=$1
export today=`date  --date='0 days ago' '+%Y%m%d'`
export dt=$today$cyc
#
src_dir=/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/meteogram
work_dir=/lfs/h2/cpc/ptmp/vadlamani.kumar/gfs/$cyc/DIR_stn2
mkdir -p $work_dir
rm $work_dir/*
cd $work_dir
#
cp $src_dir/meteogram_GDS.gs .
cp $src_dir/meteogram_subset_GDS.gs .
#---------------------------------------------------------------------
#
ln=-13.6
lt=9.6
sed "s/station/Conakry_Guinea/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=-15.52
lt=11.81
sed "s/station/Biaasu_Guinea_Bissau/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=-3.9
lt=5.2
sed "s/station/Abidjan_Ivory_coast/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=36.92
lt=-1.34
sed "s/station/Nairobi_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=34.73
lt=-0.09
sed "s/station/Kissumu_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=35.6
lt=3.1
sed "s/station/Lodwar_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=38.05
lt=2.3
sed "s/station/Marsabit_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=40.1
lt=1.8
sed "s/station/Wajir_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=35.3
lt=0.5
sed "s/station/Eldoret_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
ln=39.6
lt=-0.5
sed "s/station/Garissa_Kenya/g" meteogram_GDS.gs> meteogram.gs
perl -pi -e "s/CYC/'$cyc'/g" meteogram_subset_GDS.gs
grads -blc 'meteogram_subset_GDS.gs '$dt' '$ln' '$lt' '
grads -a 1 -bc 'meteogram.gs'
#
#-------------------------------------------------------------------------
scp $work_dir/*.png vkumar@cpcrzdm:"../www/htdocs/products/international/gfs_meteograms/$cyc/."
