* * * * * * * * * * * * *
* meteogram_subset_GDS.gs
* 
* This script will write out two small data files along with matching descriptor files.
* The files will be written to the same directory where the script is executed; any existing 
* files will be overwritten. These files contain all the variables needed to draw a meteogram,
* a multi-panel plot showing time series of forecasts for selected variables at a given location. 
* The data are downloaded from the GrADS Data Server at http://monsoondata.org:9090/dods/gefs0p25. 
* This script must be executed before running the meteogram script, meteogram_GDS.gs
* 
* The script requires three arguments: 
*    yyyymmddhh -- the initialization date of the desired forecast data
*    lon        -- the longitude of the desired location
*    lat        -- the latitude of the desired location
* 
* Written by Jennifer M. Adams (jma@iges.org)
* 
* Both scripts are available to download at: 
*   ftp://cola.gmu.edu/grads/scripts/meteogram_subset_GDS.gs
*   ftp://cola.gmu.edu/grads/scripts/meteogram_GDS.gs
* * * * * * * * * * * * * 
 
function main(args)
if (args='')
  say 'Usage: meteogram_subset_GDS <yyyymmddhh> <lon> <lat>'
  return
else
  yyyymmddhh=subwrd(args,1)
  lon=subwrd(args,2)
  lat=subwrd(args,3)
endif

* Flags for downloading both groups of data
getsubset=1
getsubsetp=1

* Open the GDS data file
*'sdfopen http://monsoondata.org:9090/dods/gefs0p25/gefs.'yyyymmddhh
*if (rc!=0)
*  say 'Error opening URL http://monsoondata.org:9090/dods/gefs0p25/gefs.'yyyymmddhh
*  return
*endif

'open /lfs/h2/cpc/ptmp/vadlamani.kumar/gefs/CYC/gefs.ctl'

'set lon 'lon
glon=subwrd(result,4)
'set lat 'lat
glat=subwrd(result,4)
*
zmax=28
tmax=81
'set gxout fwrite'

if (getsubset=1)
* Write out the variables needed for the meteogram
  '!date'
  say 'Working on mysubset.dat'
  'set fwrite mysubset.dat'
  t=1
  f=0
  while (t<=tmax)
    'set t 't
    fmod=math_fmod(t,2)
*   write out the z-varying variables
    z=1; while (z<=zmax); 'set z 'z; 'd tmpprs' ; z=z+1; endwhile
    z=1; while (z<=zmax); 'set z 'z; 'd rhprs'; z=z+1; endwhile
    if (fmod=0)
*     write out missing values for 3hr winds
      z=1; while (z<=zmax); 'd const(lat,-9.99e8,-a)' ; z=z+1; endwhile
      z=1; while (z<=zmax); 'd const(lat,-9.99e8,-a)' ; z=z+1; endwhile
    else
*     write out winds only for 6-hour increments
      z=1; while (z<=zmax); 'set z 'z; 'd ugrdprs' ; z=z+1; endwhile
      z=1; while (z<=zmax); 'set z 'z; 'd vgrdprs' ; z=z+1; endwhile
    endif
*   write out single-level variables
    'set z 1'
    'd hgtprs(lev=500)-hgtprs(lev=1000)'
    'd PRMSLmsl' 
    'd PRESsfc'  
    'd ugrd10m'
    'd vgrd10m'
    'd tmp2m' 
    'd DPT2m' 
    'd rh2m'
    if (fmod=0)
*     write out missing values for 3hr min/max
      'd const(lat,-9.99e8,-a)'
      'd const(lat,-9.99e8,-a)'
    else
*     these are 6hr min/max values
      'd tmin2m'
      'd tmax2m'
    endif
    'd no4LFTXsfc'
    'd capesfc'
* low cloud
    'd ave(TCDCprs,z=1,z=10)'
* mid cloud
    'd ave(TCDCprs,z=10,z=16)'
* high cloud
    'd ave(TCDCprs,z=16,z=28)'
    t=t+1
    f=f+3
  endwhile
  'disable fwrite'

* Create the descriptor file
  ctl='mysubset.ctl'
  rc=write(ctl,'dset ^mysubset.dat')
  rc=write(ctl,'title GEFS subset data for a meteogram',append)
  rc=write(ctl,'undef -9.99e8',append)
  xdef='xdef 1 levels 'glon ; rc=write(ctl,xdef,append)
  ydef='ydef 1 levels 'glat ; rc=write(ctl,ydef,append)
  rc=write(ctl,'zdef 28 levels ',append)
  rc=write(ctl,' 1000 975 950 925 900 850 800 750 700',append)
  rc=write(ctl,'  650 600 550 500 450 400 350 300 250',append)
  rc=write(ctl,'  200 150 100 70 50 40 30 20 15 10')
  'set t 1'; 'q time'; inittime=subwrd(result,3)
  tdef='tdef 80 linear 'inittime' 3hr'
  rc=write(ctl,tdef,append)
  rc=write(ctl,'vars 19',append)
  rc=write(ctl,'t      28  99  temperature',append)
  rc=write(ctl,'rh     28  99  relative humidity',append)
  rc=write(ctl,'u      28  99  u',append)
  rc=write(ctl,'v      28  99  v',append)
  rc=write(ctl,'thk     0  99  500-1000mb thickness',append)
  rc=write(ctl,'slp     0  99  sea level pressure',append)
  rc=write(ctl,'ps      0  99  surface pressure',append)
  rc=write(ctl,'u10m    0  99  u at 10m',append)
  rc=write(ctl,'v10m    0  99  v at 10m',append)
  rc=write(ctl,'t2m     0  99  temperature at 2m',append)
  rc=write(ctl,'td2m    0  99  dew point temperature at 2m',append)
  rc=write(ctl,'rh2m    0  99  relative humidity at 2m',append)
  rc=write(ctl,'t2min   0  99  min temperature at 2m',append)
  rc=write(ctl,'t2max   0  99  max temperature at 2m',append)
  rc=write(ctl,'li      0  99  lifted index',append)
  rc=write(ctl,'capes   0  99  CAPE at surface',append)
  rc=write(ctl,'lcc     0  99  low cloud cover',append)
  rc=write(ctl,'mcc     0  99  middle cloud cover',append)
  rc=write(ctl,'hcc     0  99  high cloud cover',append)
  rc=write(ctl,'endvars',append)
  rc=close(ctl)
endif
  
if (getsubsetp=1)
  '!date'
  say 'Working on mysubsetp.dat'
* Write out the precip variables in a separate file
  'set fwrite mysubsetp.dat'
  'set z 1'
  'set t 1'
  'd apcpsfc'
  'd crainsfc'
  'd cfrzrsfc'
  'd cicepsfc'
  'd csnowsfc'
  t=2
  while (t<=tmax-1)
*   these are 3-hourly accumulations
    t1=t-1
    'set t 't
    'd apcpsfc(t='t')-apcpsfc(t='t1')'
    'd crainsfc(t='t')-crainsfc(t='t1')'
    'd cfrzrsfc(t='t')-cfrzrsfc(t='t1')'
    'd cicepsfc(t='t')-cicepsfc(t='t1')'
    'd csnowsfc(t='t')-csnowsfc(t='t1')'
*   these are 6-hourly accumulations
*   so we must subtract the previous 3hr totals
    'set t 't+1
    'd apcpsfc-apcpsfc(t-1)  '
    'd crainsfc'
    'd cfrzrsfc'
    'd cicepsfc'
    'd csnowsfc'
    t=t+2
  endwhile
  'disable fwrite'

* Create the descriptor file
  ctl='mysubsetp.ctl'
  rc=write(ctl,'dset ^mysubsetp.dat')
  rc=write(ctl,'title GEFS subset data for a meteogram',append)
  rc=write(ctl,'undef -9.99e8',append)
  xdef='xdef 1 levels 'glon ; rc=write(ctl,xdef,append)
  ydef='ydef 1 levels 'glat ; rc=write(ctl,ydef,append)
  rc=write(ctl,'zdef 1 levels 1',append)
  'set t 1'; 'q time'; inittime=subwrd(result,3)
  tdef='tdef 80 linear 'inittime' 3hr'
  rc=write(ctl,tdef,append)
*  rc=write(ctl,'vars 6',append)
  rc=write(ctl,'vars 5',append)
  rc=write(ctl,'p     0 99 total precip',append)
*  rc=write(ctl,'pc    0 99 convective precip',append)
  rc=write(ctl,'crain 0 99 categorical rain',append)
  rc=write(ctl,'cfrzr 0 99 categorical freezing rain',append)
  rc=write(ctl,'cicep 0 99 categorical ice pellets',append)
  rc=write(ctl,'csnow 0 99 categorical snow',append)
  rc=write(ctl,'endvars',append)
  rc=close(ctl)
endif

'quit'






