#!/bin/bash 
cd /lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/gfs_meteogram
#
export cyc=18
export today=`date  --date=' 1 days ago' '+%Y%m%d'`
export dt1=`date  --date=' 1 days ago' '+%d'`
export dt2=`date  --date=' 0 days ago' '+%d'`
export ymd=$today
export ymda=`date  '+%Y%m%d'`
export ymdh=${ymd}${cyc}
#
tmpdir=/lfs/h2/cpc/ptmp/vadlamani.kumar
mkdir -p $tmpdir/gfs/${cyc}
rm $tmpdir/gfs/${cyc}/*
cd $tmpdir/gfs/${cyc}
#
gfsd=/lfs/h1/ops/prod/com/gfs/v16.3
gfsdir=$gfsd/gfs.$today/$cyc/atmos
#
typeset -i i1
i1=0
for nt in 000 003 006 009 012 015 018 021 024 027 030 033 036 039 042 045 048 051 054 057 060 063 066 069 072 075 078 081 084 087 090 093 096 099 102 105 108 111 114 117 120 123 126 129 132 135 138 141 144 147 150 153 156 159 162 165 168 171 174 177 180 183 186 189 192 195 198 201 204 207 210 213 216 219 222 225 228 231 234 237 240 243; do

let "i1=i1+1"
upd=`/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/utils/ndate +$nt $ymdh`
ymd1=`echo $upd | cut -c1-8`
hr=`echo $upd | cut -c9-10`
echo $ymd ${ymd1} $hr
echo " US NOAA NWS NCEP Day$i1 $1Z GFS forecast valid 00""Z $ymd1" > t"$i1"_24h
cp $gfsdir/gfs.t${cyc}z.pgrb2.0p25.f$nt   gfs.${ymd1}f$hr
done
#-----------------------------------------------------------------------
#
/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/utils/g2ctl gfs.${ymd}f18 > f18.ctl
gribmap  -0 -i f18.ctl
#
#-----------------------------------------------------------------------
ymdf21=${ymd}f21
/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/utils/g2ctl gfs.${ymdf21} > gfs_template.ctl
sed -e "s/dset \^gfs.${ymdf21}/dset \^gfs.\%y4\%m2\%d2f\%h2/g"  gfs_template.ctl > t2.ctl
sed -e "s/options pascals/options pascals template/g"  t2.ctl > t3.ctl
sed -e "s/tdef 1 linear 21Z${dt1}/tdef 81 linear 21Z${dt1}/g"  t3.ctl > t4.ctl
sed -e "s/1mo/3hr/g"  t4.ctl > t5.ctl
mv t5.ctl gfs21.ctl
gribmap -i gfs21.ctl
cp gfs21.ctl gfs.ctl
#
#-----------------------------------------------------------------------
ymdf00=${ymda}f00
/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/utils/g2ctl gfs.${ymdf00} > gfs_template.ctl
sed -e "s/dset \^gfs.${ymdf00}/dset \^gfs.\%y4\%m2\%d2f\%h2/g"  gfs_template.ctl > t2.ctl
sed -e "s/options pascals/options pascals template/g"  t2.ctl > t3.ctl
sed -e "s/tdef 1 linear/tdef 28 linear/g"  t3.ctl > t4.ctl
# sed -e "s/tdef 1 linear 00Z/tdef 28 linear 00Z/g"  t3.ctl > t4.ctl
sed -e "s/1mo/6hr/g"  t4.ctl > t5.ctl
mv t5.ctl gfs24.ctl
gribmap -i gfs24.ctl
cp gfs24.ctl gfs6.ctl
#-----------------------------------------------------------------------
#
exit
