#!/bin/bash -l
cd /lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/meteogram
#
export cyc=$1
tmpdir=/lfs/h2/cpc/ptmp/vadlamani.kumar
mkdir -p $tmpdir/gfs/${cyc}
rm $tmpdir/gfs/${cyc}/*
cd $tmpdir/gfs/${cyc}
gfsd=/lfs/h1/ops/prod/com/gfs/v16.2
today=`date  '+%Y%m%d'`
gfsdir=$gfsd/gfs.$today/$cyc/atmos
#
ymd=$today
ymdh=${ymd}${cyc}
#
typeset -i i1
i1=0
for nt in 000 003 006 009 012 015 018 021 024 027 030 033 036 039 042 045 048 051 054 057 060 063 066 069 072 075 078 081 084 087 090 093 096 099 102 105 108 111 114 117 120 123 126 129 132 135 138 141 144 147 150 153 156 159 162 165 168 171 174 177 180 183 186 189 192 195 198 201 204 207 210 213 216 219 222 225 228 231 234 237 240; do

let "i1=i1+1"
upd=`/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/utils/ndate +$nt $ymdh`
ymd1=`echo $upd | cut -c1-8`
hr=`echo $upd | cut -c9-10`
echo $ymd ${ymd1} $hr
echo " US NOAA NWS NCEP Day$i1 $1Z GFS forecast valid 00""Z $ymd1" > t"$i1"_24h
cp $gfsdir/gfs.t${cyc}z.pgrb2.0p25.f$nt   gfs.${ymd1}f$hr
done
#-----------------------------------------------------------------------
#
/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/utils/g2ctl gfs.${ymd}f00 > f00.ctl
gribmap -0 -i f00.ctl
#
#-----------------------------------------------------------------------
ymdf03=${ymd}f03
/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/utils/g2ctl gfs.${ymdf03} > gfs_template.ctl
sed -e "s/dset \^gfs.${ymdf03}/dset \^gfs.\%y4\%m2\%d2f\%h2/g"  gfs_template.ctl > t2.ctl
sed -e "s/options pascals/options pascals template/g"  t2.ctl > t3.ctl
sed -e "s/tdef 1 linear 03Z/tdef 80 linear 03Z/g"  t3.ctl > t4.ctl
sed -e "s/1mo/3hr/g"  t4.ctl > t5.ctl
mv t5.ctl gfs03.ctl
gribmap -i gfs03.ctl
#
#-----------------------------------------------------------------------
ymdf06=${ymd}f06
/lfs/h2/cpc/intdesk/noscrub/vadlamani.kumar/utils/g2ctl gfs.${ymdf06} > gfs_template.ctl
sed -e "s/dset \^gfs.${ymdf06}/dset \^gfs.\%y4\%m2\%d2f\%h2/g"  gfs_template.ctl > t2.ctl
sed -e "s/options pascals/options pascals template/g"  t2.ctl > t3.ctl
sed -e "s/tdef 1 linear 06Z/tdef 28 linear 06Z/g"  t3.ctl > t4.ctl
sed -e "s/1mo/6hr/g"  t4.ctl > t5.ctl
mv t5.ctl gfs06.ctl
gribmap -i gfs06.ctl
#-----------------------------------------------------------------------
#
exit
