library(ncdf4)

#----------------
# Make dimensions
#----------------
#xmodel <- 1:length(gcmtype)
xlon <- as.numeric(lon)
xlat <- as.numeric(lat)
#xens <- 1:maxens
  
#nm <- length(gcmtype)
nx <- length(xlon)
ny <- length(xlat)
#nens <- length(xens)

xdim <- ncdim_def( 'lon', 'degreesE', xlon )
ydim <- ncdim_def( 'lat', 'degreesN', xlat )
#mdim <- ncdim_def( 'model', 'number', xmodel)
#edim <- ncdim_def( 'ens' , 'month' , xens )
 
#---------
# Define the variables 
#---------
missing_val <- -9999     # missing value

pblw <- ncvar_def( 'below', '%', list(xdim,ydim), missing_val )
pabv <- ncvar_def( 'above', '%', list(xdim,ydim), missing_val )
pnor <- ncvar_def( 'normal','%', list(xdim,ydim), missing_val )
hrps <- ncvar_def( 'hrpss', '%', list(xdim,ydim), missing_val )
trps <- ncvar_def( 'trpss', '%', list(xdim,ydim), missing_val )

output_fname <- paste0(dirdat,fileName)
ncid <- nc_create( output_fname, list(pblw,pabv,pnor,hrps,trps))

#-------------------------------
# Write data 
#-------------------------------

ncvar_put( ncid, pblw, below, start=c(1,1), count=c(nx,ny))
ncvar_put( ncid, pabv, above, start=c(1,1), count=c(nx,ny))
ncvar_put( ncid, pnor, normal, start=c(1,1), count=c(nx,ny))
ncvar_put( ncid, hrps, hrpss  , start=c(1,1), count=c(nx,ny))
ncvar_put( ncid, trps, trpss  , start=c(1,1), count=c(nx,ny))

nc_close( ncid )


