
begin

 err = NhlGetErrorObjectId()
 setvalues err
    "errLevel" : "Fatal"          ; only report Fatal errors
 end setvalues

 type         = "png"
 iLead        = ILEAD
 Szn4Month    = SZNLENLGIC    ; False ==  3 month season forecast data ;
 STATE        = LOGICSTATE
 iMonth       = OMONS
 currentYr    = CURRENTYR
 SEASON       = SEASONNAME
 latS         = LATS
 latN         = LATN
 lonW         = LONW
 lonE         = LONE
 PRDCTRall    = ALLPRDCT
 COUNTRY      = MYCOUNTRY ; one of the countries below as displayed.
 Res          = OBSRES 
 printProb    = PRINTPROB
 printProbRaw = PRINTPROBRAW
 tlats        = TESTLATS
 tlatn        = TESTLATN  
 tlonw        = TESTLONW 
 tlone        = TESTLONE

 ; The order is the same as maskNameNCL
 StateNames = (/ "DZA", "BEN", "BFA", "BDI", "CMR", \
                 "COG", "COD", "CIV",               \
                 "EGY", "ETH", "GHA", "GIN", "GNB", \
                 "KEN", "LBR", "MDG", "MLI", "MAR", \
                 "MOZ", "MRT", "NER", "NGA", "RWA", \
                 "SEN", "SLE", "TZA", "GMB", "TGO", \
                 "ZMB", "ZWE" /)

 maskNameNCL  := (/"algeria", "benin", "burkina faso", "burundi", "cameroon", \
                 "congo", "Democratic Republic of the Congo", "ivory coast",\
                  "egypt", "ethiopia", "ghana", "guinea", "guinea-bissau", \
                 "kenya","liberia", "madagascar", "mali", "morocco", \
              "mozambique", "mauritania","niger","nigeria", "rwanda", \
              "senegal", "sierra leone", "tanzania", "the gambia", "togo",\
              "zambia", "zimbabwe" /)


 dircolor   =  "../colors/"
 dirSHP     =  "../shpfiles/"
 regInd     = (/1,2,7,10,11,12,14,16,19,21,22,24,25/)
 maskWAf    = maskNameNCL(regInd)
;;;;;;;;;;;;;
 dirModelRoot     = "./"
 gcmnames         = (/"canesm5","gem5nemo", "nasa","ccsm4", "cfsv2","cesm1"/)
 smodStart        = 0
 smodLast         = 5

 RASTER           = True 

; maskPlot         = False
; maskLev          = 5
 shaderaindry     = False
;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;
;;; Set lat-lon of domain

  ;;; directory where colors and shpfiles dirs  are located

 useNCLmask       = True
 if (STATE) then
     StateInd = ind(StateNames .eq. COUNTRY)
     StName = StateNames(StateInd)
     print(" ")
     print("... working for "+ str_capital(maskNameNCL(StateInd)) )  
 else
     print(" ")
     print("... working for "+ str_capital(maskWAf) )  
 end if

 landocean = (/"ocean", "land"/)

;;;; Need to have the lower r/wesolution at 0.5 for real-time verification 
     mlatLres            = toint((latN - latS)/Res + 1)
     mlonLres            = toint((lonE - lonW)/Res + 1)
     LresLat        = fspan(latS, latN, mlatLres)
     LresLon        = fspan(lonW, lonE, mlonLres)
     LresLat@units  = "degrees_north"
     LresLon@units  = "degrees_east"
     LresLat@axis   = "Y"
     LresLon@axis   = "X"
     LresLat!0      = "lat"
     LresLat&lat   = LresLat
     LresLon!0      = "lon"
     LresLon&lon   = LresLon

   month      = (/"Jan","Feb","Mar","Apr","May","Jun", \
               "Jul","Aug","Sep","Oct","Nov","Dec" /)

;;;;;;;;;;;;;;;;;;;;;;;;;;
; useNCLmask       = True    
 pthr  = 3.  ; probability difference (abs) b/n above and below 
              ; categories below which both categories are set to 
              ; missing.  
 fthr  = 3.  ; same as pthr

 VARN   = "Prec"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;; Obsfiles for plotting mean, making dry areas

 minProbLev   = 33   ; cut off probability

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Create directories for figures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   dir0 = "./epsfiles/"  ;+ COUNTRY +"/"

   system("if ! test -d " + dir0 +" ; then mkdir -p " + dir0 + " ; fi")
   plotdir = dir0
   delete(dir0)

;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;
; Set some basic resources for all

  res                                 = True
  res@gsnFrame                        = False
  res@gsnDraw                         = False
  res@gsnLeftString                   = ""
  res@gsnRightString                  = ""
  res@tfDoNDCOverlay                  = False
  res@gsnMaximize                     = False
  res@gsnAddCyclic                    = False
  res@mpDataBaseVersion               = "MediumRes"
  res@mpDataSetName                   = "Earth..4"
  res@mpGeophysicalLineThicknessF     = 4
  res@mpNationalLineThicknessF        = 4
  res@mpOutlineBoundarySets           = "Allboundaries"
  res@pmTickMarkDisplayMode           = "Always"
  res@mpLimitMode                     = "LatLon"
  res@mpFillOn                        = False
  res@mpOutlineOn                     = False
  res@cnInfoLabelOn                   = False
  res@cnConstFLabelOn                 = False
  res@cnFillOn                        = True
  res@cnLinesOn                       = False
  res@cnConstFEnableFill              = False
  res@cnNoDataLabelOn                 = False

  if (STATE) then
     f = addfile(dirSHP + "gadm41_"+StName+"_shp/" + "gadm41_"+StName+"_0.shp" ,"r")
     state_lon             = f->x
     state_lat             = f->y
     delete(f)
     min_lat               = min(state_lat)
     max_lat               = max(state_lat)
     min_lon               = min(state_lon)
     max_lon               = max(state_lon)
     res@mpMinLatF            = min_lat     ; range to zoom in on
     res@mpMaxLatF            = max_lat
     res@mpMinLonF            = min_lon
     res@mpMaxLonF            = max_lon

    f1shp = dirSHP + "gadm41_"+StName+"_shp/" + "gadm41_"+StName+"_0.shp"

    if (useNCLmask) then
         res@mpFillOn                = True
         res@mpOutlineOn             = False
         res@mpFillBoundarySets      = "NoBoundaries"
         res@mpOutlineBoundarySets   = "National"
         res@mpFillAreaSpecifiers    = landocean
         res@mpSpecifiedFillColors   = (/"lightblue","white" /)
         res@mpAreaMaskingOn         = 1
         res@mpMaskAreaSpecifiers    = (/maskNameNCL(StateInd)/)
         res@cnFillDrawOrder         = "Predraw"
         res@cnLineDrawOrder         = "Predraw"
    end if

  else
     res@mpMinLatF            = latS      ; range to zoom in on
     res@mpMaxLatF            = latN
     res@mpMinLonF            = lonW
     res@mpMaxLonF            = lonE
     if (lonE .gt. 180. )then
         res@mpCenterLonF        = (lonW + lonE)/2.
     end if
     wafm = addfile(dirSHP+"wafmask_0p5.nc","r")
     xmask = wafm->mask(0,:,:)
     delete(wafm)
     xmask = (/ where(xmask .eq. -1,xmask@_FillValue,xmask ) /)
     f1shp                  = dirSHP + "wafrica.shp"

     if (useNCLmask) then
         res@mpFillOn                = True
         res@mpOutlineOn             = False
         res@mpFillBoundarySets      = "NoBoundaries"
         res@mpOutlineBoundarySets   = "National"
         res@mpFillAreaSpecifiers    = landocean
         res@mpSpecifiedFillColors   = (/"lightblue","white" /)
         res@mpAreaMaskingOn         = 1
         res@mpMaskAreaSpecifiers    = maskWAf 
         res@cnFillDrawOrder         = "Predraw"
         res@cnLineDrawOrder         = "Predraw"
     end if
  end if

  resproball             = res
  resprob                = res

  res@cnLevelSelectionMode = "ExplicitLevels"

  res@vpWidthF           = 0.65
  res@vpHeightF          = 0.8
  res@vpXF               = 0.13
  res@vpYF               = 0.925

  resprob               = res
  resproball            = res


;;;;;;;;;;;;;;;;;;;;;;
;;; Read color files 
;;;;;;;;;;;;;;;;;;;;;;

  colorabove   = asciiread(dircolor+"colAbovePrec.txt",(/11,3/),"float")
  colorbelow   = asciiread(dircolor+"colBelowPrec.txt",(/11,3/),"float")
  colornormal  = asciiread(dircolor+"colNormalPrec.txt",(/11,3/),"float")
  coloranomaly = asciiread(dircolor+"colAnomalyTT2m.txt",(/23,3/),"float")
  coloranomaly := coloranomaly(12:,:)

  colCorr      := asciiread(dircolor+"colCorr.txt",(/12,3/),"float")
  coloranomaly := colCorr
  problevels   = (/40,45,50,60,70,80,90/)
  problabels   = problevels + ""
  pcolind      = (/0,2,4,5,6,8,9,10/)
  ;pcolind      = (/0,2,3,4,5,6,8,9/)

  anomlevels =  (/ 0.1,0.2,0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0  /)

  lnres                  = True
  lnres@gsLineColor      = "black"
  lnres@gsLineThicknessF = 2.0

  ensp  = resprob
  ensp@cnLevelSelectionMode     = "ExplicitLevels"
  ensp@cnLevels                 = problevels
  ensp@cnLineLabelsOn           = False
  ensp@lbLabelBarOn             = False
  ensp@cnFillMode                = "RasterFill"
;  ensp@lbOrientation            = "Vertical"

   bensp                           = True
   bensp@gsnDraw                   = False
   bensp@gsnFrame                  = False
   bensp@cnInfoLabelOn             = False
   bensp@cnFillOn                  = True
   bensp@cnFillMode                = "RasterFill"
   bensp@cnLinesOn                 = False
   bensp@cnLineLabelsOn            = False
   bensp@cnNoDataLabelOn           = False
   bensp@cnConstFEnableFill        = True
   bensp@cnConstFLabelOn           = False
   bensp@lbLabelBarOn              = False

   bensp@cnLevelSelectionMode      = "ExplicitLevels"
   bensp@cnLevels                  = problevels

   if (useNCLmask) then
       bensp@cnFillDrawOrder         = "Predraw"
       bensp@cnLineDrawOrder         = "Predraw"
   end if

   ranom                      = resprob
   if (RASTER) then
      ensp@cnFillMode                = "RasterFill"
      bensp@cnFillMode               = "RasterFill"
          ensp@cnFillOn                  = True
      bensp@cnFillOn                  = True

      ;ensp@cnRasterSmoothingOn        = True  ; if smoothed few remain b/se of
                                               ; missing of closeset celss
      ;bensp@cnRasterSmoothingOn        = True

      ensp@cnLinesOn                   = False
      bensp@cnLinesOn                   = False

      ranom@cnFillMode               = "RasterFill"
      ranom@cnLinesOn               =  False
      ;ranom@cnRasterSmoothingOn        = True
  else
      ensp@cnFillMode                = "CellFill"
      bensp@cnFillMode               = "CellFill"
      ranom@cnFillMode               = "CellFill"
   end if

   ranom@lbOrientation        = "Vertical"
   ranom@cnLevelSelectionMode = "ExplicitLevels"
   ranom@cnLevels             = anomlevels
   ranom@cnFillColors         = coloranomaly  ;(::-1,:)

;;;;;;;
;;; for labelbar
  plbres                      = True

; Set initial width and height.
  plbres@vpWidthF             = 0.03

; Allow more control over labelbars.
  plbres@lbAutoManage         = False

; No margins around labelbar.
  plbres@lbBottomMarginF      = 0.0
  plbres@lbLeftMarginF        = 0.0
  plbres@lbRightMarginF       = 0.0
  plbres@lbTopMarginF         = 0.0

; Turn various features on and off.
  plbres@lbLabelsOn           = True
  plbres@lbPerimOn            = False
  plbres@lbTitleOn            = True
  plbres@lbMonoFillPattern    = True
  plbres@lbOrientation        = "Vertical"
  plbres@lbLabelFontHeightF   = 0.015

  plbres@lbJustification      = "TopLeft"

  plbres@lbLabelAlignment     = "InteriorEdges"

  plbres@lbLabelJust          = "CenterLeft"
  plbres@lbLabelOffsetF       = 0.5


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Read Data and plot      
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  modDatDir  = dirModelRoot + "analdat/"
  filesReg = modDatDir

;;;; Get Dimension for grand ensemble over predictors
  PRDCTR  = PRDCTRall(0)
  FTYPES   =  "_PRCP_Multinom"+PRDCTR+"_3monthSeasonal.nc"

  if ( Szn4Month) then
      FTYPES   = "_PRCP_Multinom"+PRDCTR+"_4monthSeasonal.nc"
  end if

  allfiles = filesReg + gcmnames(0) + FTYPES

  afile := addfile(allfiles,"r")
  tmp   := afile->below
  dims  = dimsizes(tmp)
  dims0  = dimsizes(gcmnames)
  allblw = new((/dims0(0), dims(0),dims(1)/), typeof(tmp),tmp@_FillValue) 
  allblw!0 = "modl"
  allblw!1 = "lat"
  allblw!2 = "lon"
  allblw&modl = ispan(0,dims0(0)-1,1)
  allblw&lat  = tmp&lat
  allblw&lon  = tmp&lon

  allnrm = allblw
  allabv = allblw
  alltrps = allblw   ; average trpss
  allxrps = allblw  ; maximum trpss

  dlat = tmp&lat
  dlat!0 = "lat"
  dlat&lat = dlat
  dlon = tmp&lon
  dlon!0 = "lon"
  dlon&lon = dlon

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;ENSMEAN PROBABILITY
;;;;;
  do imod = 0, dimsizes(gcmnames) - 1
      
     imodname  = gcmnames(imod)
     FTYPES   :=  "_PRCP_Multinom"+PRDCTRall+"_3monthSeasonal.nc"

     if ( Szn4Month) then
        FTYPES   := "_PRCP_Multinom"+PRDCTRall+"_4monthSeasonal.nc"
     end if

     figmethods = "_Prob_Multinom"

     allfiles := filesReg + imodname + FTYPES
     fdata = addfiles(allfiles,"r")
     ListSetType (fdata, "join")
 
     tbelow  := fdata[:]->below
     tabove  := fdata[:]->above
     tnormal := fdata[:]->normal
     hrpss   := fdata[:]->hrpss
     trpss   := fdata[:]->trpss

     xblw    := new(dimsizes(tbelow),typeof(tbelow),tbelow@_FillValue)
     copy_VarCoords(tbelow, xblw)
     xabv    := xblw
     xnrm    := xblw

     xtmp    := hrpss
     xtmp     = (/where(xtmp .lt. 0, 0, xtmp)/)
     xtmpsum := dim_sum_n_Wrap(xtmp,0)
     xtmpsum = (/ where(xtmpsum .eq. 0, xtmpsum@_FillValue,xtmpsum) /)

     xblw    = (/tbelow * xtmp /)
     xnrm    = (/tnormal * xtmp /)
     xabv    = (/tabove * xtmp /)

     tbelow  := dim_sum_n_Wrap(xblw,0)
     tabove  := dim_sum_n_Wrap(xabv,0)
     tnormal := dim_sum_n_Wrap(xnrm,0)
     tbelow   = (/tbelow / xtmpsum /) 
     tnormal  = (/tnormal/ xtmpsum /) 
     tabove   = (/tabove / xtmpsum /) 

     tbelow@units = ""
     tabove@units = ""
     tnormal@units = ""

;;;;;;;;
     t0 := tbelow
     t0 = t0@_FillValue
     t1 := t0
     t2 := t0

     t0Raw := t0
     t1Raw := t1
     t2Raw := t2

;;;;;
;;;;;ENSEMBLE PROCESSED PROBABILITY DATA FOR SEPARATE PLOTING
;;;;;

        dim := dimsizes(t0)
        ydim = dim(0) - 1
        xdim = dim(1) - 1
        do j = 0,ydim
           do i = 0, xdim
              vv   = new(3, float , -9999 )

              vv(0) = tbelow(j,i)
              vv(1) = tnormal(j,i)
              vv(2) = tabove(j,i)

	      t0Raw(j,i) = tbelow(j,i)
              t1Raw(j,i) = tnormal(j,i)
              t2Raw(j,i) = tabove(j,i)

              ix = maxind(vv)
              if (ismissing(ix)) then
                 t0(j,i) = (/t0@_FillValue/)
                 t1(j,i) = (/t1@_FillValue/)
                 t2(j,i) = (/t2@_FillValue/)
              else
                 if ( ix .eq. 0 .and. vv(0) .ge. minProbLev) then
                    t0(j,i) = (/vv(0)/)
                 end if
                 if (ix .eq. 1 .and. vv(1) .ge. minProbLev) then
                    t1(j,i) = (/vv(1)/)
                 end if
                 if (ix .eq. 2 .and. vv(2) .ge. minProbLev)  then
                    t2(j,i) = (/vv(2)/)
                 end if
              end if

              v02 := abs(vv(0)   - vv(2))
              v01 := abs(vv(0)   - vv(1))
              v12 := abs(vv(1)   - vv(2))

              if (.not. ismissing(ix)) then
                 if (ix .eq. 0 .or. ix .eq. 2) then
                    if ( .not. ismissing(v02) .and. v02 .le. pthr) then
                       t0(j,i) = (/t0@_FillValue/) ;white if no signf. diff
                       t2(j,i) = (/t2@_FillValue/) ;white if no signf. diff
                       if (.not. ismissing(vv(1)) .and. vv(1) .gt. minProbLev) then
                          t1(j,i) = (/ vv(1) /)
                       else
                          t1(j,i) = (/t1@_FillValue/)
                       end if
                       ix  = 102  ; Normal favored for A or B when A-B < pthr
                       ;print(ix + " " + vv(0)+ " " + vv(1) + " " + vv(2) )
                       ;print(ix + " " + t0(j,i)+ " " + t1(j,i)+ " " + t2(j,i))
                    end if
                 end if

                 if (ix .eq. 0 .or. ix .eq. 1) then   ; favor normal
                    if ( .not. ismissing(v01) .and. v01 .le. pthr) then
                       t0(j,i) = (/t0@_FillValue/)  ;white if no signf. diff
                       t2(j,i) = (/t2@_FillValue /) ;white if no signf. diff
                       if (.not. ismissing(vv(1)) .and. vv(1) .gt. minProbLev) then
                          t1(j,i) = (/ vv(1) /)
                       else
                          t1(j,i) = (/t1@_FillValue/)
                       end if
                       ix  = 101 ; Normal favored for B or N when B-N < pthr
                       ;print(ix + " " + vv(0)+ " " + vv(1) + " " + vv(2) )
                       ;print(ix + " " + t0(j,i)+ " " + t1(j,i)+ " " + t2(j,i))
                    end if
                 end if

                 if (ix .eq. 1 .or. ix .eq. 2) then   ; favor normal
                    if ( .not. ismissing(v12) .and. v12 .le. pthr) then
                       t0(j,i) = (/t0@_FillValue/)  ;white if no signf. diff
                       t2(j,i) = (/t2@_FillValue /) ;white if no signf. diff
                       if (.not. ismissing(vv(1)) .and. vv(1) .gt. minProbLev) then
                          t1(j,i) = (/ vv(1) /)
                       else
                          t1(j,i) = (/t1@_FillValue/)
                       end if
                       ix  = 112  ;Normal favored for A or N when A-N < pthr
                       ;print(ix + " " + vv(0)+ " " + vv(1) + " " + vv(2) )
                       ;print(ix + " " + t0(j,i)+ " " + t1(j,i)+ " " + t2(j,i))
                    end if
                 end if
              else
                 t0(j,i) = (/t0@_FillValue/)  ; white  no sig.
                 t2(j,i) = (/t2@_FillValue /) ; white if no signf.
                 t1(j,i) = (/ vv(1) /)
                 ix  = 199  ;Normal favored for indeterminate
              end if

              delete([/ix,vv/])
           end do ; i xdiim
        end do ; j ydim

     t0file := t0
     t1file := t1
     t2file := t2

     allblw(imod,:,:) = (/ t0 /)
     allnrm(imod,:,:) = (/ t1 /)
     allabv(imod,:,:) = (/ t2 /)

     if (printProb) then
        lts = ind(dlat .eq. tlats)
        ltn = ind(dlat .eq. tlatn)
        lnw = ind(dlon .eq. tlonw)
        lne = ind(dlon .eq. tlone)

        if (printProbRaw) then
           tb := t0Raw(lts:ltn, lnw:lne)
           ta := t2Raw(lts:ltn, lnw:lne)
           tn := t1Raw(lts:ltn, lnw:lne)
        else
           tb := t0file(lts:ltn, lnw:lne)
           ta := t2file(lts:ltn, lnw:lne)
           tn := t1file(lts:ltn, lnw:lne)
        end if

        tb@_FillValue = -999
        ta@_FillValue = -999
        tn@_FillValue = -999

        xx  := trpss
        xx  = (/ where(xx .le. -0.1, xx@_FillValue,xx)/)
        xx = (/ where(xx .ge.  1.0, xx@_FillValue,xx)/)

        xx := dim_avg_n_Wrap(xx,0)

        tt := xx(lts:ltn, lnw:lne)
        tt@_FillValue = -999
        ;printMinMax(tt, 0)
        plat = "Lat: " +dlat(lts) + " " + dlat(ltn)
        plon = "Lon: " +dlon(lnw) + " " + dlon(lne)
        print((/plon/))
        print((/plat/))

        nx   = (lne-lnw+1)
        ny   = (ltn - lts + 1)
        xlon  = new((/1, nx/),float)
        xlon(0,:) = tofloat(dlon(lnw:lne))

        tb  := table_attach_rows(xlon,tb,0)
        tn  := table_attach_rows(xlon,tn,0)
        ta  := table_attach_rows(xlon,ta,0)
        tt  := table_attach_rows(xlon,tt,0)

     ; if I want to attach latitudes to the left, I need to increase ny by 1
     ; to account for the added longitudes
        xlat  = new((/ny+1,1 /),float)
        xlat(0,0) = -999
        xlat(1:(ny),0) = tofloat(dlat(lts:ltn))

        fmtx = (lne-lnw+1)+"f6.0"
        tb  := table_attach_columns(xlat,tb,0)
        tn  := table_attach_columns(xlat,tn,0)
        ta  := table_attach_columns(xlat,ta,0)
        tt  := table_attach_columns(xlat,tt,0)

        ;; Need to add 1 to nx to account for the attached longitude
        fmtx := (nx+1)+"f6.0"
        opt = True
        opt@title  = "Avg: Below "
        write_matrix(tb, fmtx,opt)
        opt@title  = "Avg: Above "
        write_matrix(ta, fmtx,opt)
        opt@title  = "Avg: Normal"
        write_matrix(tn, fmtx,opt)
        fmtx := (nx+1)+"f7.1"
        opt@title  = "Avg: target RPSS "
        write_matrix(tt, fmtx,opt)
     end if
   	
;;;;;
;;;;;PLOT ENSEMBBLE BELOW PROBABILITY
;;;;;
        xname  = plotdir +  "rpssWtd_"+imodname + "_"+VARN +  \
                     "_"+iLead+"monLead" +  figmethods

        wks = gsn_open_wks(type,xname)

        tmp = t0
        ensp@cnFillPalette             = colorbelow(pcolind,:)
        cntrb = gsn_csm_contour_map(wks,tmp,ensp)
        poly1 = gsn_add_shapefile_polylines(wks,cntrb,f1shp,lnres)
        if (type .eq. "png" .or. type .eq. "eps" .or. STATE) then
;          poly1 = gsn_add_shapefile_polylines(wks,cntrb,dirSHP+f1shp,lnres)
        end if
        delete([/tmp,ensp@cnFillPalette/])

;;;;;
;;;;;PLOT ENSEMBLE NEAR NORMAL PROBABILITY
;;;;;
        tmp = t1
        bensp@cnFillPalette            = colornormal(pcolind,:)
        cntrn = gsn_csm_contour(wks,tmp,bensp)
        delete([/tmp,bensp@cnFillPalette/])

;;;;;
;;;;;PLOT ENSEMBLE ABOVE PROBABILITY
;;;;;
        tmp = t2
        bensp@cnFillPalette             = colorabove(pcolind,:)
        cntra = gsn_csm_contour(wks,tmp,bensp)
        delete([/tmp,bensp@cnFillPalette/])

;;;;;
;;;;;ENSEMBLE LABELBAR
;;;;;
        txres               = True
        txres@txFontHeightF = 0.015
        txres@txAngleF      = 90.

        getvalues cntrb                      ; Get plot size for use in
           "vpHeightF" : vph                 ; creating labelbar.
           "vpWidthF"  : vpw
           "vpXF"      : vpx
           "vpYF"      : vpy
        end getvalues
        plbres@vpHeightF            = vph/3. +0.04

        xpos = vpw+vpx+0.01
        ypos = (1.-vpy)+ vph/3 + 0.1 -0.02  
        ytxt = ypos - 0.10
        plbres@lbBoxMinorExtentF    = 1.0
        plbres@lbFillColors         = colorbelow(pcolind,:) ;plbresB
        lbid1 = gsn_create_labelbar_ndc(wks,dimsizes(problevels)+1,problabels, \
                                   xpos,ypos,plbres)
        gsn_text_ndc(wks," Below (%) " ,xpos+0.11 ,ytxt,txres)

        ypos = ypos + vph/3 + 0.005
        ytxt = ypos - 0.09
        delete(plbres@lbFillColors)
        plbres@lbFillColors         = colornormal(pcolind,:)
        lbid2 = gsn_create_labelbar_ndc(wks,dimsizes(problevels)+1,problabels, \
                                   xpos,ypos,plbres)
        gsn_text_ndc(wks," Normal (%) " ,xpos+0.11,ytxt,txres)
        delete(plbres@lbFillColors)


        ypos = ypos + vph/3 + 0.005
        ytxt = ypos - 0.09
        plbres@lbFillColors         = colorabove(pcolind,:)
        lbid3 = gsn_create_labelbar_ndc(wks,dimsizes(problevels)+1,problabels, \
                                   xpos,ypos,plbres)
        gsn_text_ndc(wks," Above (%) " ,xpos+0.11,ytxt,txres)

;;;;;
;;;;;ENSEMBLE OVERLAY
;;;;;
        overlay(cntrb,cntrn)
        overlay(cntrb,cntra)
        if (shaderaindry) then
           overlay(cntrb,cntrx)
           draw(cntrb)
        else
           draw(cntrb)
        end if

        draw(lbid1)
        draw(lbid2)
        draw(lbid3)

        frame(wks)
        delete(wks)
        delete([/txres,lbid1,lbid2,lbid3/])

;;;;;
;;;;; Single model skill plot

        trpss = (/ where(trpss .le. -0.1, trpss@_FillValue,trpss)/)
        trpss = (/ where(trpss .ge.  1.0, trpss@_FillValue,trpss)/)

        tmp := dim_max_n_Wrap(trpss,0)
        alltrps(imod,:,:) = (/ tmp /)
        tmp := dim_avg_n_Wrap(trpss,0)
        allxrps(imod,:,:) = (/ tmp /)

        figName  =  plotdir +  "AvgtRPSS_" + imodname  +\
                          "_"+iLead+"monLead" + figmethods
        wks = gsn_open_wks(type,figName)
        tmp := alltrps(imod,:,:)
        cntra = gsn_csm_contour_map(wks,tmp,ranom)
        poly1 = gsn_add_shapefile_polylines(wks,cntra,f1shp,lnres)
        draw(cntra)
        frame(wks)
        delete(wks)
        printMinMax(tmp,0)

        figName  =  plotdir +  "MaxtRPSS_" + imodname  +\
                          "_"+iLead+"monLead" + figmethods
        wks = gsn_open_wks(type,figName)
        tmp := allxrps(imod,:,:)
        cntra = gsn_csm_contour_map(wks,tmp,ranom)
        poly1 = gsn_add_shapefile_polylines(wks,cntra,f1shp,lnres)
        draw(cntra)
        frame(wks)
        delete(wks)
        printMinMax(tmp,0)

	;;;;; End individual Skill plot	
        delete([/ tbelow, tabove,tnormal,hrpss, trpss/])

  end do ; iprd

;;;;;
;;;;;PLOT Grand Ensemble for all predictors
;;;;;
        figName  =  plotdir +  "GrandAvgtRPSS_" +\
                          iLead+"monLead" + figmethods
        wks = gsn_open_wks(type,figName)
        tmp := dim_avg_n_Wrap(alltrps,0)
        cntra = gsn_csm_contour_map(wks,tmp,ranom)
        poly1 = gsn_add_shapefile_polylines(wks,cntra,f1shp,lnres)
        draw(cntra)
        frame(wks)
        delete(wks)
        printMinMax(tmp,0)

	figName  =  plotdir +  "GrandMaxtRPSS_"  +\
                          iLead+"monLead" + figmethods
        wks = gsn_open_wks(type,figName)
        tmp := dim_max_n_Wrap(allxrps,0)
        cntra = gsn_csm_contour_map(wks,tmp,ranom)
        poly1 = gsn_add_shapefile_polylines(wks,cntra,f1shp,lnres)
        draw(cntra)
        frame(wks)
        delete(wks)
        printMinMax(tmp,0)


;;;;;

end 
