 
begin
; CHANGE Aug by the intital month (e.g. Jan, Feb, Mar, Apr, May, Jun
;                                  (Jul, Aug, Sep, Oct, Nov, Dec) 
iMon = OMONS
YYYY = CURRENTYR  ; forecast  year
SEASON = SEASONNAME 
yrS = FIRSTYR    
yrE = LASTYR     
Leadi = LEADI
Leadf = LEADF

lonWeof = LonWEOF
lonEeof = LonEEOF
latSeof = LatSEOF
latNeof = LatNEOF

numeof = NUMEOF ; number of EOF/PC
yrSc = CLIMYRS
yrEc = CLIMYRE

optETS = True ; for PC/EOF tiemseries
optETS@jopt  = 1 ; use correlation matrix
optEOF       = True ; for Eigenvectors/EOFs
optEOF@pcrit = 60 ; at least 60 percent data for a given time series
optEOF@jopt  = 1  ; for correlation matrix

;droot = "/cpc/nmme/"
;hcst  = "/hcst_new/"
;fcst   = ".ENSMEAN.fcst.nc"
;ddhh   = "0100/"

munits  = "months since 1981-01-01 00:00:00"
dunits  = "days since 1981-01-01 00:00:00"

opt  = 0  ; use sample standard deviation

ThisYr = YYYY
ftpsite = "https://ftp.cpc.ncep.noaa.gov/International/nmme/netcdf/"
varname  = ".tmpsfc."
EnsName  = ".ENSMEAN.fcst.nc"

lonpoint = 0.0
lonpoint@units = "degrees_east"
lonpoint@axis  = "X"
latpoint       = 0.0
latpoint@units = "degrees_north"
latpoint@axis  = "Y"

;gcmnames <- c("CanSIP","NASA","GFDLS","CCSM4", "CFSv2","CESM1" /)
canesm5  = True
gem5nemo = True  ; True
nasa     = True
ccsm4    = True
cfsv2    = True
cesm1    = True
gfdlS    = False

monthdef     = (/"", "Jan","Feb","Mar","Apr","May","Jun", \
               "Jul","Aug","Sep","Oct","Nov","Dec" /)

XXX=monthdef(iMon) ; Month in 3 letters
XXX = XXX + ThisYr

latwnpS = 13.   ; WNP -- From Funk et al BAMS 2018   
latwnpE = 30.   ;        Western V sst = (z(WNP)+z(WEV))/2  
lonwnpS = 160.  ; start  lon
lonwnpE = 220.  ; end   lon for western north Pacific 

latwnpS = 20.   ; WNP -- As defined in WC draft on 17 Aug 2022
latwnpE = 35.   ; end  lat
lonwnpS = 160.  ; start  lon
lonwnpE = 210.  ; end   lon for western north Pacific 

latwepS = -20.  ; WEP -- From Funk et al. BAMS 2018        
latwepE = 20.   ; end
lonwepS = 120.  ; start
lonwepE = 170.  ; end  lon for western equatorial Pacific 

latwepS = -15.  ; WEP -- As defined in WC draft 17Aug2022
latwepE = 20.   ; end
lonwepS = 120.  ; start
lonwepE = 160.  ; end  lon for western equatorial Pacific 

latwspS = -30.  ; WSP -- As defined in WC draft 17Aug2022
latwspE = -15.  ; end
lonwspS = 155.  ; start
lonwspE = 210.  ; end  lon for western equatorial Pacific 

latni4S = -5.    ; start lat for Nino 4
latni4E = 5.    ; end
lonni4S = 160.  ; start
lonni4E = 210.  ; end  lon for Nino 4 

latn34S = -5.    ; start lat for Nino34
latn34E = 5.    ; end
lonn34S = 190.  ; start
lonn34E = 240.  ; end  lon for Nino34

latwioS = -10.
latwioE =  10.
lonwioS =  50.
lonwioE =  70.

lateioS =   -10.
lateioE =  0.
loneioS =  90.
loneioE =  110.

latwsoS = -37.
latwsoE = -27.
lonwsoS =  55.
lonwsoE =  65.

latesoS = -28.
latesoE = -18.
lonesoS =  90.
lonesoE =  100.

dir0 = "./analdat/"
system("if ! test -d " + dir0 +" ; then mkdir " + dir0 + " ; fi")

dir0 = "./sstdat/"
system("if ! test -d " + dir0 +" ; then mkdir " + dir0 + " ; fi")
dirsst = dir0 

;;;;;;;;;;;;;;;;;;;;;;
;;;;; CanESM5
;;;;;;;;;;;;;;;;;;;;;;
 if (canesm5) then

   print("... downloading canESM5 ")
   xModel = "CanESM5"

   myftp = ftpsite + str_lower(XXX) + "ic/" + xModel+"/"
   myftp = myftp + xModel+varname + "[1991-"+ThisYr+"]" + iMon+ EnsName
   x := systemfunc(" curl -O "+ myftp)
   fnames  := systemfunc(" ls -1 " + xModel + "*.nc")
   a := addfiles(fnames,"r")
   ListSetType (a, "join")

   print("... downloaded data for canESM5 ")

  x := a[:]->fcst

  if (any(isnan_ieee(x))) then
     if(.not.isatt(x,"_FillValue")) then
         x@_FillValue = -9999.  ;default_fillvalue(typeof(prec))
         x@missing_value = -9999.
     end if
     replace_ieeenan (x, -9999., 0)
     x@missing_value = -9999.
  end if

  xunt := a[0]->fcst@units
  if (xunt .eq. "K" .or. xunt .eq. "Kelvin" .or. xunt .eq. "kelvin" .or. xunt .eq. "degK") then
         x = (/x - 273.5/)
         xunt = "degC"
  end if

  lat   = a[0]->lat
  lon   = a[0]->lon
  lat!0 = "lat"
  lon!0 = "lon"
  lat&lat = lat
  lon&lon = lon

  times = a[:]->initial_time
  target := a[0]->target  ; interested on the length of the lead

  yyyymm = cd_calendar(times,-1)
  allyrs = yyyymm/100

  nyrs    = dimsizes(times)
  ntarget = dimsizes(target)
  nlat    = dimsizes(lat)
  nlon    = dimsizes(lon)

  sstall = reshape(x,(/nyrs,ntarget,nlat,nlon/))

  sstall!0 = "time"
  sstall!1 = "lead"
  sstall!2 = "lat"
  sstall!3 = "lon"

  time         := cd_convert(times, dunits)
  sstall&time  = time
  sstall&lead  = ispan(0, ntarget - 1,1)
  sstall&lat   = lat
  sstall&lon   = lon
  sstall@_FillValue = -9999
  sstall@description = "Global Surface Temperature/SST"
  sstall@units       = xunt

  ii     = ind(allyrs .ge. toint(yrS) .and. allyrs .le. toint(YYYY))
  iclim  := ind(allyrs .ge. toint(yrSc) .and. allyrs .le. toint(yrEc))

  sst1 = dim_avg_n_Wrap(sstall(:,Leadi:Leadf,:,:),1)
  clim   :=  sst1(iclim, : ,:)
  clisd :=  dim_stddev_n(clim,0)
  clisd  = (/where (clisd .eq. 0, clisd@_FillValue,clisd) /)
  clisd := 1./clisd
  climn :=  dim_avg_n(clim,0)

  sst := sst1(ii,:,:)
  clisd := conform_dims(dimsizes(sst), clisd,(/1,2/))
  climn := conform_dims(dimsizes(sst), climn,(/1,2/))
  sst = (/ (sst - climn) * clisd /)

  printVarSummary(sst)
  delete([/a,x,ii, lat,lon,sst1, sstall,clisd,climn,clim,iclim /])

  wnp =  sst(:,{latwnpS:latwnpE},{lonwnpS:lonwnpE})
  wnp := dim_avg_n_Wrap(wnp,(/1,2/))

  wep =  sst(:,{latwepS:latwepE},{lonwepS:lonwepE})
  wep := dim_avg_n_Wrap(wep,(/1,2/))

  ni4 =  sst(:,{latni4S:latni4E},{lonni4S:lonni4E})
  ni4 := dim_avg_n_Wrap(ni4,(/1,2/))

  n34 =  sst(:,{latn34S:latn34E},{lonn34S:lonni4E})
  n34 := dim_avg_n_Wrap(n34,(/1,2/))

  wsp =  sst(:,{latwspS:latwspE},{lonwspS:lonwspE})
  wsp := dim_avg_n_Wrap(wsp,(/1,2/))

  wv  = wnp
  wv  = (/ (wnp + wep + wsp)/3 /)

  wvg  = n34
  wvg  = (/ n34 - wv /)

  wio := sst(:,{latwioS:latwioE},{lonwioS:lonwioE})
  wio := dim_avg_n_Wrap(wio,(/1,2/))

  eio := sst(:,{lateioS:lateioE},{loneioS:loneioE})
  eio := dim_avg_n_Wrap(eio,(/1,2/))

  iod := wio
  iod  = (/wio - eio /)

  wso := sst(:,{latwsoS:latwsoE},{lonwsoS:lonwsoE})
  wso := dim_avg_n_Wrap(wso,(/1,2/))

  eso := sst(:,{latesoS:latesoE},{lonesoS:lonesoE})
  eso := dim_avg_n_Wrap(eso,(/1,2/))

  siod := wso
  siod  = (/wso - eso /)
  xmodNam = "canesm5"
; Save data on local disk
  fname := dirsst+"sstIndex"+SEASON+ xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")

       fAtt               = True            ; assign file attributes
       fAtt@title         = "Standardied SST index for NMME"
       fAtt@source_file   =  "NMME for " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)
       ncdf->wnp  = wnp
       ncdf->wep  = wep
       ncdf->ni4  = ni4
       ncdf->n34  = n34
       ncdf->wvg  = wvg
       ncdf->wio  = wio
       ncdf->eio  = eio
       ncdf->iod  = iod
       ncdf->siod = siod
  ;;;;;;
  ;;; Do EOF analysis
  sstall := sst(:,{latSeof:latNeof}, {lonWeof:lonEeof}) ; do pca for specified region
  ev    := eofunc_n_Wrap(sstall,numeof, optEOF,0) ; numEOF x nlat x nlon
  ev_ts := eofunc_ts_n_Wrap(sstall,ev,optETS,0)   ; a matrix of numEOF x ntime

  ev@_FillValue  = -9999
  ttime := ispan(1,numeof, 1)
  ttime@units = "months from 2025-01-01 00:0:00 "
  ev!0  = "time"
  ev!1  = "lat"
  ev!2  = "lon"
  ev&time  = ttime
  ev&lat = sstall&lat
  ev&lon = sstall&lon

  ev_ts@_FillValue = -9999
  fmtf   = numeof + "f9.2"
  opttxt = True
  opttxt@fout = dirsst + "eofts" + SEASON + xmodNam + ".txt"
  write_matrix(transpose(ev_ts),fmtf,opttxt)
  ;print(ev_ts(0,:))
  fname := dirsst+"eofVec"+SEASON + xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")
       fAtt               = True            ; assign file attributes
       fAtt@title         = "NMME SST Eigenvector"
       fAtt@source_file   =  "NMME for  " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)

       ncdf->eof  = ev

   x := systemfunc("rm "+ xModel + "*.nc")

   delete([/ ev, ev_ts, yyyymm, allyrs, sst,times, ncdf,fname, fnames, sstall/])
   delete([/ wv, wsp, wvg, wnp, wep, ni4, n34, wio, eio,iod, siod, wso,eso/])

end if


;;;;;;;;;;;;;;;;;;;;;;
;;;;; "GEM5.2_NEMO"
;;;;;;;;;;;;;;;;;;;;;;

 if (gem5nemo) then

   xmodNam = "gem5nemo"
   print("... preparing GEM5.2_NEMO ")
   xModel = "GEM5.2_NEMO"

   myftp = ftpsite + str_lower(XXX) + "ic/" + xModel+"/"
   myftp = myftp + xModel+varname + "[1991-"+ThisYr+"]" + iMon+ EnsName
   x := systemfunc(" curl -O "+ myftp)
   fnames  := systemfunc(" ls -1 " + xModel + "*.nc")
   a := addfiles(fnames,"r")
   ListSetType (a, "join")

   print("...Done reading data ")

   x := a[:]->fcst

   if (any(isnan_ieee(x))) then
     if(.not.isatt(x,"_FillValue")) then
         x@_FillValue = -9999.  ;default_fillvalue(typeof(prec))
         x@missing_value = -9999.
     end if
     replace_ieeenan (x, -9999., 0)
     x@missing_value = -9999.
   end if

   xunt := a[0]->fcst@units

   if (xunt .eq. "K" .or. xunt .eq. "Kelvin" .or. xunt .eq. "kelvin" .or. xunt .eq. "degK") then
         x = (/x - 273.5/)
         xunt = "degC"
   end if

  lat   = a[0]->lat
  lon   = a[0]->lon
  lat!0 = "lat"
  lon!0 = "lon"
  lat&lat = lat
  lon&lon = lon

  times = a[:]->initial_time
  target := a[0]->target  ; interested on the length of the lead

  yyyymm = cd_calendar(times,-1)
  allyrs = yyyymm/100

  nyrs    = dimsizes(times)
  ntarget = dimsizes(target)
  nlat    = dimsizes(lat)
  nlon    = dimsizes(lon)

  sstall = reshape(x,(/nyrs,ntarget,nlat,nlon/))

  sstall!0 = "time"
  sstall!1 = "lead"
  sstall!2 = "lat"
  sstall!3 = "lon"

  time         := cd_convert(times, dunits)
  sstall&time  = time
  sstall&lead  = ispan(0, ntarget - 1,1)
  sstall&lat   = lat
  sstall&lon   = lon
  sstall@_FillValue = -9999
  sstall@description = "Global Surface Temperature/SST"
  sstall@units       = xunt

  ii     = ind(allyrs .ge. toint(yrS) .and. allyrs .le. toint(YYYY))
  iclim  := ind(allyrs .ge. toint(yrSc) .and. allyrs .le. toint(yrEc))

  sst1 = dim_avg_n_Wrap(sstall(:,Leadi:Leadf,:,:),1)
  clim   :=  sst1(iclim, : ,:)
  clisd :=  dim_stddev_n(clim,0)
  clisd  = (/where (clisd .eq. 0, clisd@_FillValue,clisd) /)
  clisd := 1./clisd
  climn :=  dim_avg_n(clim,0)

  sst := sst1(ii,:,:)
  clisd := conform_dims(dimsizes(sst), clisd,(/1,2/))
  climn := conform_dims(dimsizes(sst), climn,(/1,2/))
  sst = (/ (sst - climn) * clisd /)

  printVarSummary(sst)
  delete([/a,x,ii, lat,lon,sst1, sstall,clisd,climn,clim,iclim /])

  wnp =  sst(:,{latwnpS:latwnpE},{lonwnpS:lonwnpE})
  wnp := dim_avg_n_Wrap(wnp,(/1,2/))

  wep =  sst(:,{latwepS:latwepE},{lonwepS:lonwepE})
  wep := dim_avg_n_Wrap(wep,(/1,2/))

  ni4 =  sst(:,{latni4S:latni4E},{lonni4S:lonni4E})
  ni4 := dim_avg_n_Wrap(ni4,(/1,2/))

  n34 =  sst(:,{latn34S:latn34E},{lonn34S:lonni4E})
  n34 := dim_avg_n_Wrap(n34,(/1,2/))

  wsp =  sst(:,{latwspS:latwspE},{lonwspS:lonwspE})
  wsp := dim_avg_n_Wrap(wsp,(/1,2/))

  wv  = wnp
  wv  = (/ (wnp + wep + wsp)/3 /)

  wvg  = n34
  wvg  = (/ n34 - wv /)

  wio := sst(:,{latwioS:latwioE},{lonwioS:lonwioE})
  wio := dim_avg_n_Wrap(wio,(/1,2/))

  eio := sst(:,{lateioS:lateioE},{loneioS:loneioE})
  eio := dim_avg_n_Wrap(eio,(/1,2/))

  iod := wio
  iod  = (/wio - eio /)

  wso := sst(:,{latwsoS:latwsoE},{lonwsoS:lonwsoE})
  wso := dim_avg_n_Wrap(wso,(/1,2/))

  eso := sst(:,{latesoS:latesoE},{lonesoS:lonesoE})
  eso := dim_avg_n_Wrap(eso,(/1,2/))

  siod := wso
  siod  = (/wso - eso /)

  ; Save data on local disk
  fname := dirsst+"sstIndex"+SEASON+ xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")

       fAtt               = True            ; assign file attributes
       fAtt@title         = "Standardied SST index for NMME"
       fAtt@source_file   =  "NMME for " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)
       ncdf->wnp  = wnp
       ncdf->wep  = wep
       ncdf->ni4  = ni4
       ncdf->n34  = n34
       ncdf->wvg  = wvg
       ncdf->wio  = wio
       ncdf->eio  = eio
       ncdf->iod  = iod
       ncdf->siod = siod
  ;;;;;;
  ;;; Do EOF analysis
  sstall := sst(:,{latSeof:latNeof}, {lonWeof:lonEeof}) ; do pca for specified region
  ev    := eofunc_n_Wrap(sstall,numeof, optEOF,0) ; numEOF x nlat x nlon
  ev_ts := eofunc_ts_n_Wrap(sstall,ev,optETS,0)   ; a matrix of numEOF x ntime

  ev@_FillValue  = -9999
  ttime := ispan(1,numeof, 1)
  ttime@units = "months from 2025-01-01 00:0:00 "
  ev!0  = "time"
  ev!1  = "lat"
  ev!2  = "lon"
  ev&time  = ttime
  ev&lat = sstall&lat
  ev&lon = sstall&lon

  ev_ts@_FillValue = -9999
  fmtf   = numeof + "f9.2"
  opttxt = True
  opttxt@fout = dirsst + "eofts" + SEASON + xmodNam + ".txt"
  write_matrix(transpose(ev_ts),fmtf,opttxt)
  ;print(ev_ts(0,:))
  fname := dirsst+"eofVec"+SEASON + xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")
       fAtt               = True            ; assign file attributes
       fAtt@title         = "NMME SST Eigenvector"
       fAtt@source_file   =  "NMME for  " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)

       ncdf->eof  = ev

   x := systemfunc("rm "+ xModel + "*.nc")

   delete([/ ev, ev_ts, yyyymm, allyrs, sst,times, ncdf,fname, fnames, sstall/])
   delete([/ wv, wsp, wvg, wnp, wep, ni4, n34, wio, eio,iod, siod, wso,eso/])

end if

;;;;;;;;;;;;;;;;;;;;;;
;;;;; "NASA_GEOS5v2"
;;;;;;;;;;;;;;;;;;;;;;

 if (nasa) then

   xmodNam = "nasa"
   print("... preparing NASA_GEOS5v2 ")
   xModel = "NASA_GEOS5v2"

   myftp = ftpsite + str_lower(XXX) + "ic/" + xModel+"/"
   myftp = myftp + xModel+varname + "[1991-"+ThisYr+"]" + iMon+ EnsName
   x := systemfunc(" curl -O "+ myftp)
   fnames  := systemfunc(" ls -1 " + xModel + "*.nc")
   a := addfiles(fnames,"r")
   ListSetType (a, "join")

   print("... downloaded data for " + xModel)

   x := a[:]->fcst
   if (any(isnan_ieee(x))) then
     if(.not.isatt(x,"_FillValue")) then
         x@_FillValue = -9999.  ;default_fillvalue(typeof(prec))
         x@missing_value = -9999.
     end if
     replace_ieeenan (x, -9999., 0)
     x@missing_value = -9999.
   end if

   xunt := a[0]->fcst@units

   if (xunt .eq. "K" .or. xunt .eq. "Kelvin" .or. xunt .eq. "kelvin" .or. xunt .eq. "degK") then
         x = (/x - 273.5/)
	 xunt = "degC"
   end if

  lat   = a[0]->lat
  lon   = a[0]->lon
  lat!0 = "lat"
  lon!0 = "lon"
  lat&lat = lat
  lon&lon = lon

  times = a[:]->initial_time
  target := a[0]->target  ; interested on the length of the lead

  yyyymm = cd_calendar(times,-1)
  allyrs = yyyymm/100

  nyrs    = dimsizes(times)
  ntarget = dimsizes(target)
  nlat    = dimsizes(lat)
  nlon    = dimsizes(lon)

  sstall = reshape(x,(/nyrs,ntarget,nlat,nlon/))

  sstall!0 = "time"
  sstall!1 = "lead"
  sstall!2 = "lat"
  sstall!3 = "lon"

  time         := cd_convert(times, dunits)
  sstall&time  = time
  sstall&lead  = ispan(0, ntarget - 1,1)
  sstall&lat   = lat
  sstall&lon   = lon
  sstall@_FillValue = -9999
  sstall@description = "Global Surface Temperature/SST"
  sstall@units       = xunt

  ii     = ind(allyrs .ge. toint(yrS) .and. allyrs .le. toint(YYYY))
  iclim  := ind(allyrs .ge. toint(yrSc) .and. allyrs .le. toint(yrEc))

  sst1 = dim_avg_n_Wrap(sstall(:,Leadi:Leadf,:,:),1)
  clim   :=  sst1(iclim, : ,:)
  clisd :=  dim_stddev_n(clim,0)
  clisd  = (/where (clisd .eq. 0, clisd@_FillValue,clisd) /)
  clisd := 1./clisd
  climn :=  dim_avg_n(clim,0)

  sst := sst1(ii, :,:)
  clisd := conform_dims(dimsizes(sst), clisd,(/1,2/))
  climn := conform_dims(dimsizes(sst), climn,(/1,2/))
  sst = (/ (sst - climn) * clisd /)

  printVarSummary(sst)
  delete([/a,x,ii, lat,lon,sst1, sstall,clisd,climn,clim,iclim /])

  wnp =  sst(:,{latwnpS:latwnpE},{lonwnpS:lonwnpE})
  wnp := dim_avg_n_Wrap(wnp,(/1,2/))

  wep =  sst(:,{latwepS:latwepE},{lonwepS:lonwepE})
  wep := dim_avg_n_Wrap(wep,(/1,2/))

  ni4 =  sst(:,{latni4S:latni4E},{lonni4S:lonni4E})
  ni4 := dim_avg_n_Wrap(ni4,(/1,2/))

  n34 =  sst(:,{latn34S:latn34E},{lonn34S:lonni4E})
  n34 := dim_avg_n_Wrap(n34,(/1,2/))

  wsp =  sst(:,{latwspS:latwspE},{lonwspS:lonwspE})
  wsp := dim_avg_n_Wrap(wsp,(/1,2/))

  wv  = wnp
  wv  = (/ (wnp + wep + wsp)/3 /)

  wvg  = n34
  wvg  = (/ n34 - wv /)

  wio := sst(:,{latwioS:latwioE},{lonwioS:lonwioE})
  wio := dim_avg_n_Wrap(wio,(/1,2/))

  eio := sst(:,{lateioS:lateioE},{loneioS:loneioE})
  eio := dim_avg_n_Wrap(eio,(/1,2/))

  iod := wio
  iod  = (/wio - eio /)

  wso := sst(:,{latwsoS:latwsoE},{lonwsoS:lonwsoE})
  wso := dim_avg_n_Wrap(wso,(/1,2/))

  eso := sst(:,{latesoS:latesoE},{lonesoS:lonesoE})
  eso := dim_avg_n_Wrap(eso,(/1,2/))

  siod := wso
  siod  = (/wso - eso /)

  ; Save data on local disk
  fname := dirsst+"sstIndex"+SEASON+ xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")

       fAtt               = True            ; assign file attributes
       fAtt@title         = "Standardied SST index for NMME"
       fAtt@source_file   =  "NMME for " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)
       ncdf->wnp  = wnp
       ncdf->wep  = wep
       ncdf->ni4  = ni4
       ncdf->n34  = n34
       ncdf->wvg  = wvg
       ncdf->wio  = wio
       ncdf->eio  = eio
       ncdf->iod  = iod
       ncdf->siod = siod
  ;;;;;;
  ;;; Do EOF analysis
  sstall := sst(:,{latSeof:latNeof}, {lonWeof:lonEeof}) ; do pca for specified region
  ev    := eofunc_n_Wrap(sstall,numeof, optEOF,0) ; numEOF x nlat x nlon
  ev_ts := eofunc_ts_n_Wrap(sstall,ev,optETS,0)   ; a matrix of numEOF x ntime

  ev@_FillValue  = -9999
  ttime := ispan(1,numeof, 1)
  ttime@units = "months from 2025-01-01 00:0:00 "
  ev!0  = "time"
  ev!1  = "lat"
  ev!2  = "lon"
  ev&time  = ttime
  ev&lat = sstall&lat
  ev&lon = sstall&lon

  ev_ts@_FillValue = -9999
  fmtf   = numeof + "f9.2"
  opttxt = True
  opttxt@fout = dirsst + "eofts" + SEASON + xmodNam + ".txt"
  write_matrix(transpose(ev_ts),fmtf,opttxt)
  ;print(ev_ts(0,:))
  fname := dirsst+"eofVec"+SEASON + xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")
       fAtt               = True            ; assign file attributes
       fAtt@title         = "NMME SST Eigenvector"
       fAtt@source_file   =  "NMME for  " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)

       ncdf->eof  = ev

   x := systemfunc("rm "+ xModel + "*.nc")
   delete([/ ev, ev_ts, yyyymm, allyrs, sst,times, ncdf,fname, fnames, sstall/])
   delete([/ wv, wsp, wvg, wnp, wep, ni4, n34, wio, eio,iod, siod, wso,eso/])

end if


;;;;;;;;;;;;;;;;;;;;;;
;;;;;  "NCAR_CCSM4"
;;;;;;;;;;;;;;;;;;;;;;

 if (ccsm4) then

   xmodNam = "ccsm4"
   print("... preparing  NCAR_CCSM4 ")
   xModel =  "NCAR_CCSM4"

   myftp = ftpsite + str_lower(XXX) + "ic/" + xModel+"/"
   myftp = myftp + xModel+varname + "[1991-"+ThisYr+"]" + iMon+ EnsName
   x := systemfunc(" curl -O "+ myftp)
   fnames  := systemfunc(" ls -1 " + xModel + "*.nc")
   a := addfiles(fnames,"r")
   ListSetType (a, "join")

   print("... downloaded data for " + xModel)

   x := a[:]->fcst
   if (any(isnan_ieee(x))) then
     if(.not.isatt(x,"_FillValue")) then
         x@_FillValue = -9999.  ;default_fillvalue(typeof(prec))
         x@missing_value = -9999.
     end if
     replace_ieeenan (x, -9999., 0)
     x@missing_value = -9999.
   end if

   xunt := a[0]->fcst@units

  if (xunt .eq. "K" .or. xunt .eq. "Kelvin" .or. xunt .eq. "kelvin" .or. xunt .eq. "degK") then
         x = (/x - 273.5/)
         xunt = "degC"
   end if

  x := a[:]->fcst
  if (any(isnan_ieee(x))) then
     if(.not.isatt(x,"_FillValue")) then
         x@_FillValue = -9999.  ;default_fillvalue(typeof(prec))
         x@missing_value = -9999.
     end if
     replace_ieeenan (x, -9999., 0)
     x@missing_value = -9999.
  end if

  lat   = a[0]->lat
  lon   = a[0]->lon
  lat!0 = "lat"
  lon!0 = "lon"
  lat&lat = lat
  lon&lon = lon

  times = a[:]->initial_time
  target := a[0]->target  ; interested on the length of the lead

  yyyymm = cd_calendar(times,-1)
  allyrs = yyyymm/100

  nyrs    = dimsizes(times)
  ntarget = dimsizes(target)
  nlat    = dimsizes(lat)
  nlon    = dimsizes(lon)

  sstall = reshape(x,(/nyrs,ntarget,nlat,nlon/))

  sstall!0 = "time"
  sstall!1 = "lead"
  sstall!2 = "lat"
  sstall!3 = "lon"

  time         := cd_convert(times, dunits)
  sstall&time  = time
  sstall&lead  = ispan(0, ntarget - 1,1)
  sstall&lat   = lat
  sstall&lon   = lon
  sstall@_FillValue = -9999
  sstall@description = "Global Surface Temperature/SST"
  sstall@units       = xunt

  ii     = ind(allyrs .ge. toint(yrS) .and. allyrs .le. toint(YYYY))
  iclim  := ind(allyrs .ge. toint(yrSc) .and. allyrs .le. toint(yrEc))

  sst1 = dim_avg_n_Wrap(sstall(:,Leadi:Leadf,:,:),1)
  clim   :=  sst1(iclim, : ,:)
  clisd :=  dim_stddev_n(clim,0)
  clisd  = (/where (clisd .eq. 0, clisd@_FillValue,clisd) /)
  clisd := 1./clisd
  climn :=  dim_avg_n(clim,0)

  sst := sst1(ii,:,:)
  clisd := conform_dims(dimsizes(sst), clisd,(/1,2/))
  climn := conform_dims(dimsizes(sst), climn,(/1,2/))
  sst = (/ (sst - climn) * clisd /)

  printVarSummary(sst)
  delete([/a,x,ii, lat,lon,sst1, sstall,clisd,climn,clim,iclim /])

  wnp =  sst(:,{latwnpS:latwnpE},{lonwnpS:lonwnpE})
  wnp := dim_avg_n_Wrap(wnp,(/1,2/))

  wep =  sst(:,{latwepS:latwepE},{lonwepS:lonwepE})
  wep := dim_avg_n_Wrap(wep,(/1,2/))

  ni4 =  sst(:,{latni4S:latni4E},{lonni4S:lonni4E})
  ni4 := dim_avg_n_Wrap(ni4,(/1,2/))

  n34 =  sst(:,{latn34S:latn34E},{lonn34S:lonni4E})
  n34 := dim_avg_n_Wrap(n34,(/1,2/))

  wsp =  sst(:,{latwspS:latwspE},{lonwspS:lonwspE})
  wsp := dim_avg_n_Wrap(wsp,(/1,2/))

  wv  = wnp
  wv  = (/ (wnp + wep + wsp)/3 /)

  wvg  = n34
  wvg  = (/ n34 - wv /)

  wio := sst(:,{latwioS:latwioE},{lonwioS:lonwioE})
  wio := dim_avg_n_Wrap(wio,(/1,2/))

  eio := sst(:,{lateioS:lateioE},{loneioS:loneioE})
  eio := dim_avg_n_Wrap(eio,(/1,2/))

  iod := wio
  iod  = (/wio - eio /)

  wso := sst(:,{latwsoS:latwsoE},{lonwsoS:lonwsoE})
  wso := dim_avg_n_Wrap(wso,(/1,2/))

  eso := sst(:,{latesoS:latesoE},{lonesoS:lonesoE})
  eso := dim_avg_n_Wrap(eso,(/1,2/))

  siod := wso
  siod  = (/wso - eso /)

  ; Save data on local disk
  fname := dirsst+"sstIndex"+SEASON+ xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")

       fAtt               = True            ; assign file attributes
       fAtt@title         = "Standardied SST index for NMME"
       fAtt@source_file   =  "NMME for " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)
       ncdf->wnp  = wnp
       ncdf->wep  = wep
       ncdf->ni4  = ni4
       ncdf->n34  = n34
       ncdf->wvg  = wvg
       ncdf->wio  = wio
       ncdf->eio  = eio
       ncdf->iod  = iod
       ncdf->siod = siod
  ;;;;;;
  ;;; Do EOF analysis
  sstall := sst(:,{latSeof:latNeof}, {lonWeof:lonEeof}) ; do pca for specified region
  ev    := eofunc_n_Wrap(sstall,numeof, optEOF,0) ; numEOF x nlat x nlon
  ev_ts := eofunc_ts_n_Wrap(sstall,ev,optETS,0)   ; a matrix of numEOF x ntime

  ev@_FillValue  = -9999
  ttime := ispan(1,numeof, 1)
  ttime@units = "months from 2025-01-01 00:0:00 "
  ev!0  = "time"
  ev!1  = "lat"
  ev!2  = "lon"
  ev&time  = ttime
  ev&lat = sstall&lat
  ev&lon = sstall&lon

  ev_ts@_FillValue = -9999
  fmtf   = numeof + "f9.2"
  opttxt = True
  opttxt@fout = dirsst + "eofts" + SEASON + xmodNam + ".txt"
  write_matrix(transpose(ev_ts),fmtf,opttxt)
  ;print(ev_ts(0,:))
  fname := dirsst+"eofVec"+SEASON + xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")
       fAtt               = True            ; assign file attributes
       fAtt@title         = "NMME SST Eigenvector"
       fAtt@source_file   =  "NMME for  " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)

       ncdf->eof  = ev

   x := systemfunc("rm "+ xModel + "*.nc")

   delete([/ ev, ev_ts, yyyymm, allyrs, sst,times, ncdf,fname, fnames, sstall/])
   delete([/ wv, wsp, wvg, wnp, wep, ni4, n34, wio, eio,iod, siod, wso,eso/])

end if

;;;;;;;;;;;;;;;;;;;;;;
;;;;;  "CFSv2"
;;;;;;;;;;;;;;;;;;;;;;

 if (cfsv2) then

   xmodNam = "cfsv2"
   print("... preparing  CFSv2")
   xModel =  "CFSv2"

   myftp = ftpsite + str_lower(XXX) + "ic/" + xModel+"/"
   myftp = myftp + xModel+varname + "[1991-"+ThisYr+"]" + iMon+ EnsName
   x := systemfunc(" curl -O "+ myftp)
   fnames  := systemfunc(" ls -1 " + xModel + "*.nc")
   a := addfiles(fnames,"r")
   ListSetType (a, "join")

   print("... downloaded data for " + xModel)

   x := a[:]->fcst
   if (any(isnan_ieee(x))) then
     if(.not.isatt(x,"_FillValue")) then
         x@_FillValue = -9999.  ;default_fillvalue(typeof(prec))
         x@missing_value = -9999.
     end if
     replace_ieeenan (x, -9999., 0)
     x@missing_value = -9999.
   end if

   xunt := a[0]->fcst@units

   if (xunt .eq. "K" .or. xunt .eq. "Kelvin" .or. xunt .eq. "kelvin" .or. xunt .eq. "degK") then
         x = (/x - 273.5/)
         xunt = "degC"
   end if

  lat   = a[0]->lat
  lon   = a[0]->lon
  lat!0 = "lat"
  lon!0 = "lon"
  lat&lat = lat
  lon&lon = lon

  times = a[:]->initial_time
  target := a[0]->target  ; interested on the length of the lead

  yyyymm = cd_calendar(times,-1)
  allyrs = yyyymm/100

  nyrs    = dimsizes(times)
  ntarget = dimsizes(target)
  nlat    = dimsizes(lat)
  nlon    = dimsizes(lon)

  sstall = reshape(x,(/nyrs,ntarget,nlat,nlon/))

  sstall!0 = "time"
  sstall!1 = "lead"
  sstall!2 = "lat"
  sstall!3 = "lon"

  time         := cd_convert(times, dunits)
  sstall&time  = time
  sstall&lead  = ispan(0, ntarget - 1,1)
  sstall&lat   = lat
  sstall&lon   = lon
  sstall@_FillValue = -9999
  sstall@description = "Global Surface Temperature/SST"
  sstall@units       = xunt

  ii     = ind(allyrs .ge. toint(yrS) .and. allyrs .le. toint(YYYY))
  iclim  := ind(allyrs .ge. toint(yrSc) .and. allyrs .le. toint(yrEc))

  sst1 = dim_avg_n_Wrap(sstall(:,Leadi:Leadf,:,:),1)
  clim   :=  sst1(iclim, : ,:)
  clisd :=  dim_stddev_n(clim,0)
  clisd  = (/where (clisd .eq. 0, clisd@_FillValue,clisd) /)
  clisd := 1./clisd
  climn :=  dim_avg_n(clim,0)

  sst := sst1(ii,:,:)
  clisd := conform_dims(dimsizes(sst), clisd,(/1,2/))
  climn := conform_dims(dimsizes(sst), climn,(/1,2/))
  sst = (/ (sst - climn) * clisd /)

  printVarSummary(sst)
  delete([/a,x,ii, lat,lon,sst1, sstall,clisd,climn,clim,iclim /])

  wnp =  sst(:,{latwnpS:latwnpE},{lonwnpS:lonwnpE})
  wnp := dim_avg_n_Wrap(wnp,(/1,2/))

  wep =  sst(:,{latwepS:latwepE},{lonwepS:lonwepE})
  wep := dim_avg_n_Wrap(wep,(/1,2/))

  ni4 =  sst(:,{latni4S:latni4E},{lonni4S:lonni4E})
  ni4 := dim_avg_n_Wrap(ni4,(/1,2/))

  n34 =  sst(:,{latn34S:latn34E},{lonn34S:lonni4E})
  n34 := dim_avg_n_Wrap(n34,(/1,2/))

  wsp =  sst(:,{latwspS:latwspE},{lonwspS:lonwspE})
  wsp := dim_avg_n_Wrap(wsp,(/1,2/))

  wv  = wnp
  wv  = (/ (wnp + wep + wsp)/3 /)

  wvg  = n34
  wvg  = (/ n34 - wv /)

  wio := sst(:,{latwioS:latwioE},{lonwioS:lonwioE})
  wio := dim_avg_n_Wrap(wio,(/1,2/))

  eio := sst(:,{lateioS:lateioE},{loneioS:loneioE})
  eio := dim_avg_n_Wrap(eio,(/1,2/))

  iod := wio
  iod  = (/wio - eio /)

  wso := sst(:,{latwsoS:latwsoE},{lonwsoS:lonwsoE})
  wso := dim_avg_n_Wrap(wso,(/1,2/))

  eso := sst(:,{latesoS:latesoE},{lonesoS:lonesoE})
  eso := dim_avg_n_Wrap(eso,(/1,2/))

  siod := wso
  siod  = (/wso - eso /)

  ; Save data on local disk
  fname := dirsst+"sstIndex"+SEASON+ xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")

       fAtt               = True            ; assign file attributes
       fAtt@title         = "Standardied SST index for NMME"
       fAtt@source_file   =  "NMME for " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)
       ncdf->wnp  = wnp
       ncdf->wep  = wep
       ncdf->ni4  = ni4
       ncdf->n34  = n34
       ncdf->wvg  = wvg
       ncdf->wio  = wio
       ncdf->eio  = eio
       ncdf->iod  = iod
       ncdf->siod = siod
  ;;;;;;
  ;;; Do EOF analysis
  sstall := sst(:,{latSeof:latNeof}, {lonWeof:lonEeof}) ; do pca for specified region
  ev    := eofunc_n_Wrap(sstall,numeof, optEOF,0) ; numEOF x nlat x nlon
  ev_ts := eofunc_ts_n_Wrap(sstall,ev,optETS,0)   ; a matrix of numEOF x ntime

  ev@_FillValue  = -9999
  ttime := ispan(1,numeof, 1)
  ttime@units = "months from 2025-01-01 00:0:00 "
  ev!0  = "time"
  ev!1  = "lat"
  ev!2  = "lon"
  ev&time  = ttime
  ev&lat = sstall&lat
  ev&lon = sstall&lon

  ev_ts@_FillValue = -9999
  fmtf   = numeof + "f9.2"
  opttxt = True
  opttxt@fout = dirsst + "eofts" + SEASON + xmodNam + ".txt"
  write_matrix(transpose(ev_ts),fmtf,opttxt)
  ;print(ev_ts(0,:))
  fname := dirsst+"eofVec"+SEASON + xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")
       fAtt               = True            ; assign file attributes
       fAtt@title         = "NMME SST Eigenvector"
       fAtt@source_file   =  "NMME for  " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)

       ncdf->eof  = ev

   x := systemfunc("rm "+ xModel + "*.nc")

   delete([/ ev, ev_ts, yyyymm, allyrs, sst,times, ncdf,fname, fnames, sstall/])
   delete([/ wv, wsp, wvg, wnp, wep, ni4, n34, wio, eio,iod, siod, wso,eso/])

end if



;;;;;;;;;;;;;;;;;;;;;;
;;;;;  "NCAR_CESM1"
;;;;;;;;;;;;;;;;;;;;;;

 if (cesm1) then

   xmodNam = "cesm1"
   print("... preparing   NCAR_CESM1")
   xModel =  "NCAR_CESM1"

   myftp = ftpsite + str_lower(XXX) + "ic/" + xModel+"/"
   myftp = myftp + xModel+varname + "[1991-"+ThisYr+"]" + iMon+ EnsName
   x := systemfunc(" curl -O "+ myftp)
   fnames  := systemfunc(" ls -1 " + xModel + "*.nc")
   a := addfiles(fnames,"r")
   ListSetType (a, "join")

   print("... downloaded data for " + xModel)

   x := a[:]->fcst
   if (any(isnan_ieee(x))) then
     if(.not.isatt(x,"_FillValue")) then
         x@_FillValue = -9999.  ;default_fillvalue(typeof(prec))
         x@missing_value = -9999.
     end if
     replace_ieeenan (x, -9999., 0)
     x@missing_value = -9999.
   end if

   xunt := a[0]->fcst@units
   if (xunt .eq. "K" .or. xunt .eq. "Kelvin" .or. xunt .eq. "kelvin" .or. xunt .eq. "degK") then
         x = (/x - 273.5/)
         xunt = "degC"
   end if

  lat   = a[0]->lat
  lon   = a[0]->lon
  lat!0 = "lat"
  lon!0 = "lon"
  lat&lat = lat
  lon&lon = lon

  times = a[:]->initial_time
  target := a[0]->target  ; interested on the length of the lead

  yyyymm = cd_calendar(times,-1)
  allyrs = yyyymm/100

  nyrs    = dimsizes(times)
  ntarget = dimsizes(target)
  nlat    = dimsizes(lat)
  nlon    = dimsizes(lon)

  sstall = reshape(x,(/nyrs,ntarget,nlat,nlon/))

  sstall!0 = "time"
  sstall!1 = "lead"
  sstall!2 = "lat"
  sstall!3 = "lon"

  time         := cd_convert(times, dunits)
  sstall&time  = time
  sstall&lead  = ispan(0, ntarget - 1,1)
  sstall&lat   = lat
  sstall&lon   = lon
  sstall@_FillValue = -9999
  sstall@description = "Global Surface Temperature/SST"
  sstall@units       = xunt


  ii     = ind(allyrs .ge. toint(yrS) .and. allyrs .le. toint(YYYY))
  iclim  := ind(allyrs .ge. toint(yrSc) .and. allyrs .le. toint(yrEc))

  sst1 = dim_avg_n_Wrap(sstall(:,Leadi:Leadf,:,:),1)
  clim   :=  sst1(iclim, : ,:)
  clisd :=  dim_stddev_n(clim,0)
  clisd  = (/where (clisd .eq. 0, clisd@_FillValue,clisd) /)
  clisd := 1./clisd
  climn :=  dim_avg_n(clim,0)

  sst := sst1(ii,:,:)
  clisd := conform_dims(dimsizes(sst), clisd,(/1,2/))
  climn := conform_dims(dimsizes(sst), climn,(/1,2/))
  sst = (/ (sst - climn) * clisd /)

  printVarSummary(sst)
  delete([/a,x,ii, lat,lon,sst1, sstall,clisd,climn,clim,iclim /])

  wnp =  sst(:,{latwnpS:latwnpE},{lonwnpS:lonwnpE})
  wnp := dim_avg_n_Wrap(wnp,(/1,2/))

  wep =  sst(:,{latwepS:latwepE},{lonwepS:lonwepE})
  wep := dim_avg_n_Wrap(wep,(/1,2/))

  ni4 =  sst(:,{latni4S:latni4E},{lonni4S:lonni4E})
  ni4 := dim_avg_n_Wrap(ni4,(/1,2/))

  n34 =  sst(:,{latn34S:latn34E},{lonn34S:lonni4E})
  n34 := dim_avg_n_Wrap(n34,(/1,2/))

  wsp =  sst(:,{latwspS:latwspE},{lonwspS:lonwspE})
  wsp := dim_avg_n_Wrap(wsp,(/1,2/))

  wv  = wnp
  wv  = (/ (wnp + wep + wsp)/3 /)

  wvg  = n34
  wvg  = (/ n34 - wv /)

  wio := sst(:,{latwioS:latwioE},{lonwioS:lonwioE})
  wio := dim_avg_n_Wrap(wio,(/1,2/))

  eio := sst(:,{lateioS:lateioE},{loneioS:loneioE})
  eio := dim_avg_n_Wrap(eio,(/1,2/))

  iod := wio
  iod  = (/wio - eio /)

  wso := sst(:,{latwsoS:latwsoE},{lonwsoS:lonwsoE})
  wso := dim_avg_n_Wrap(wso,(/1,2/))

  eso := sst(:,{latesoS:latesoE},{lonesoS:lonesoE})
  eso := dim_avg_n_Wrap(eso,(/1,2/))

  siod := wso
  siod  = (/wso - eso /)

  ; Save data on local disk
  fname := dirsst+"sstIndex"+SEASON+ xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")

       fAtt               = True            ; assign file attributes
       fAtt@title         = "Standardied SST index for NMME"
       fAtt@source_file   =  "NMME for " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)
       ncdf->wnp  = wnp
       ncdf->wep  = wep
       ncdf->ni4  = ni4
       ncdf->n34  = n34
       ncdf->wvg  = wvg
       ncdf->wio  = wio
       ncdf->eio  = eio
       ncdf->iod  = iod
       ncdf->siod = siod
  ;;;;;;
  ;;; Do EOF analysis
  sstall := sst(:,{latSeof:latNeof}, {lonWeof:lonEeof}) ; do pca for specified region
  ev    := eofunc_n_Wrap(sstall,numeof, optEOF,0) ; numEOF x nlat x nlon
  ev_ts := eofunc_ts_n_Wrap(sstall,ev,optETS,0)   ; a matrix of numEOF x ntime

  ev_ts@_FillValue = -9999
  ev@_FillValue  = -9999

  ttime := ispan(1,numeof, 1)
  ttime@units = "months from 2025-01-01 00:0:00 "
  ev!0  = "time"
  ev!1  = "lat"
  ev!2  = "lon"
  ev&time  = ttime
  ev&lat = sstall&lat
  ev&lon = sstall&lon

  fmtf   = numeof + "f9.2"
  opttxt = True
  opttxt@fout = dirsst + "eofts" + SEASON + xmodNam + ".txt"
  write_matrix(transpose(ev_ts),fmtf,opttxt)
  ;print(ev_ts(0,:))
  fname := dirsst+"eofVec"+SEASON + xmodNam + ".nc"
  system("/bin/rm -f "+fname)
  ncdf = addfile(fname, "c")
       fAtt               = True            ; assign file attributes
       fAtt@title         = "NMME SST Eigenvector"
       fAtt@source_file   =  "NMME for  " + xModel
       fAtt@Conventions   = "None"
       fAtt@creation_date = systemfunc ("date")
       fileattdef( ncdf, fAtt )            ; copy file attributes

       filedimdef(ncdf,"time",-1,True)

       ncdf->eof  = ev

   x := systemfunc("rm "+ xModel + "*.nc")
   delete([/ ev, ev_ts, yyyymm, allyrs, sst,times, ncdf,fname, fnames, sstall/])
   delete([/ wv, wsp, wvg, wnp, wep, ni4, n34, wio, eio,iod, siod, wso,eso/])

end if

end

