#!/bin/bash

latS=-26.
latN=-12.0
lonW=41.0
lonE=51.
lonWeof=50.
lonEeof=110.
latSeof=-35.
latNeof=20.
numeof=6  # This's the number of EOF PCs retained in the EOF 
          #analysis. Currently up to 5 EOFs are used in the stat model
	  # but only nprdFcst are used as the first predictor in the Stat Model,
	  # Of these, only 2 PCs are added as the 1st predictor. See note below

startmon=10     ### This is for model initial month
obsstartmon=11  # This is start of validation month (historical)
obsendmon=1     # This is end of valid month (hist/obs)
obsendday=31    # last day number of $obsendmonh
currentyr=2025
seasonname='"NDJ"'
tmpszn="NDJ"
sznlen=3
ilead=1  # ilead and leadi must be the same 
         # It's the difference b/n init month and 1st verifying mon of the fcst
leadi=1
leadf=3
trainLength=20  # number of years/cases for training
nprdFirst=10    # of the total predictors, how many needed as first model param
               # must be the same length as allpredctor, which you can increase
	       # or decreasing by adding or removing EOF PCs
szn4mon="False"     
isstate="True"
firstyr=2001
endyr=2020
obst='"RFE"'
tmpobst="RFE"
obsprecip=\""prec"${tmpszn}"_"${firstyr}"-"${currentyr}$tmpobst".nc"\"
echo `date`
mycountry='"MDG"'      
yrsstsc=1991
yrsstec=2020
allprdctor='(/"IOD", "SIOD", "Nino34", "WVG","PC1","PC2","PC3","PC4","PC5","PC6"/)'
monthly="True"
obsres=0.5
printProb="True"
printProbRaw="True"
tlats=-20.
tlatn=-16.
tlonw=44.0
tlone=47.0

#one of the countries below as displayed.
# The order is the same as maskNameNCL
# StateNames = (/ "DZA", "BEN", "BFA", "BDI", "CMR", \
#                 "COG", "COD", "CIV",               \
#                 "EGY", "ETH", "GHA", "GIN", "GNB", \
#                 "KEN", "LBR", "MDG", "MLI", "MAR", \
#                 "MOZ", "MRT","NER","NGA", "RWA", \
#                 "SEN", "SLE","TZA", "GMB", "TGO", \
#                  "ZMB", "ZWE" /)

# maskNameNCL  := (/"algeria", "benin", "burkina faso", "burundi", "cameroon", \
#                 "congo", "Democratic Republic of the Congo", "ivory coast",\
#                  "egypt", "ethiopia", "ghana", "guinea", "guinea-bissau", \
#                 "kenya","liberia", "madagascar", "mali", "morocco", \
#              "mozambique", "mauritania","niger", "nigeria", "rwanda",\
#                "senegal", "sierra leone", "tanzania", "the gambia", "togo",\
#                  "zambia", "zimbabwe" /)

########
#1. Activate renv before running any script by typing conda activate renv
#########

unameout="$(uname -s)"
if [ $unameout = "Darwin" ]; then

#####
#2 Get observational validation data
#####
cp ./templateObs.ncl obsPrecip.ncl
sed -i '' -E "9s|OBSMONS|$obsstartmon|" ./obsPrecip.ncl 
sed -i '' -E "10s|OBSMONE|$obsendmon|" ./obsPrecip.ncl 
sed -i '' -E "11s|OBSDAYE|$obsendday|" ./obsPrecip.ncl 
sed -i '' -E "12s|SEASONNAME|$seasonname|" ./obsPrecip.ncl
sed -i '' -E "13s|FIRSTYR|$firstyr|" ./obsPrecip.ncl 
sed -i '' -E "14s|LASTYR|$currentyr|" ./obsPrecip.ncl 
sed -i '' -E "15s|LATS|$latS|" ./obsPrecip.ncl 
sed -i '' -E "16s|LATN|$latN|" ./obsPrecip.ncl 
sed -i '' -E "17s|LONW|$lonW|" ./obsPrecip.ncl 
sed -i '' -E "18s|LONE|$lonE|" ./obsPrecip.ncl 
sed -i '' -E "19s|OBST|$obst|" ./obsPrecip.ncl 
sed -i '' -E "20s|MONTHLY|$monthly|" ./obsPrecip.ncl
sed -i '' -E "21s|OBSRES|$obsres|" ./obsPrecip.ncl

ncl obsPrecip.ncl

######################
#3. Get Model predicted SST 
######################
cp ./template1LeadSSTDownloadStdz.ncl sstDownloadStdz.ncl

sed -i '' -E "5s|OMONS|$startmon|" ./sstDownloadStdz.ncl
sed -i '' -E "6s|CURRENTYR|$currentyr|" ./sstDownloadStdz.ncl
sed -i '' -E "7s|SEASONNAME|$seasonname|" ./sstDownloadStdz.ncl
sed -i '' -E "8s|FIRSTYR|$firstyr|" ./sstDownloadStdz.ncl
sed -i '' -E "9s|LASTYR|$endyr|" ./sstDownloadStdz.ncl
sed -i '' -E "10s|LEADI|$leadi|" ./sstDownloadStdz.ncl
sed -i '' -E "11s|LEADF|$leadf|" ./sstDownloadStdz.ncl

sed -i '' -E "13s|LonWEOF|$lonWeof|" ./sstDownloadStdz.ncl
sed -i '' -E "14s|LonEEOF|$lonEeof|" ./sstDownloadStdz.ncl
sed -i '' -E "15s|LatSEOF|$latSeof|" ./sstDownloadStdz.ncl
sed -i '' -E "16s|LatNEOF|$latNeof|" ./sstDownloadStdz.ncl

sed -i '' -E "18s|NUMEOF|$numeof|" ./sstDownloadStdz.ncl
sed -i '' -E "19s|CLIMYRS|$yrsstsc|" ./sstDownloadStdz.ncl
sed -i '' -E "20s|CLIMYRE|$yrsstec|" ./sstDownloadStdz.ncl

ncl sstDownloadStdz.ncl

#####################
#4. Run the Rscript to do tge logistic regression
##############
cp ./templateSST1LeadDriver.R  multiNominalRegression.R

sed -i '' -E "30s|OMONS|$startmon|" ./multiNominalRegression.R
sed -i '' -E "31s|SZNLEN|$sznlen|" ./multiNominalRegression.R
sed -i '' -E "32s|CURRENTYR|$currentyr|" ./multiNominalRegression.R
sed -i '' -E "33s|SEASONNAME|$seasonname|" ./multiNominalRegression.R
sed -i '' -E "34s|OBSPRECIP|$obsprecip|" ./multiNominalRegression.R
sed -i '' -E "35s|FIRSTYR|$firstyr|" ./multiNominalRegression.R
sed -i '' -E "36s|LASTYR|$endyr|" ./multiNominalRegression.R
sed -i '' -E "37s|ILEAD|$ilead|" ./multiNominalRegression.R
sed -i '' -E "38s|TRAINLEN|$trainLength|" ./multiNominalRegression.R
sed -i '' -E "39s|NPRDFIRST|$nprdFirst|" ./multiNominalRegression.R

Rscript multiNominalRegression.R 

#########
#5. Plot for Nino34 predictor without checking significance 
########
prdctor='"Nino34"'

cp ./templateIndividualProb.ncl ./plotSingleModelN34.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelN34.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelN34.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelN34.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelN34.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelN34.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelN34.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelN34.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelN34.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelN34.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelN34.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelN34.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelN34.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelN34.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelN34.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelN34.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelN34.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelN34.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelN34.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelN34.ncl

ncl plotSingleModelN34.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelN34.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelN34.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelN34.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelN34.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelN34.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelN34.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelN34.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelN34.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelN34.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelN34.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelN34.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelN34.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelN34.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelN34.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelN34.ncl  
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelN34.ncl  
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelN34.ncl  
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelN34.ncl  
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelN34.ncl  
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelN34.ncl  

ncl plotAvgModelN34.ncl

#########
#6. Plot for WVG but only when significant  
########
prdctor='"WVG"'

cp ./templateIndividualProb.ncl ./plotSingleModelWVG.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelWVG.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelWVG.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelWVG.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelWVG.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelWVG.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelWVG.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelWVG.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelWVG.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelWVG.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelWVG.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelWVG.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelWVG.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelWVG.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelWVG.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelWVG.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelWVG.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelWVG.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelWVG.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelWVG.ncl

ncl plotSingleModelWVG.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelWVG.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelWVG.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelWVG.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelWVG.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelWVG.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelWVG.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelWVG.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelWVG.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelWVG.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelWVG.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelWVG.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelWVG.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelWVG.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelWVG.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelWVG.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelWVG.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelWVG.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelWVG.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelWVG.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelWVG.ncl

ncl plotAvgModelWVG.ncl

#########
#7. Plot for IOD predictor without checking significance 
########
prdctor='"IOD"'

cp ./templateIndividualProb.ncl ./plotSingleModelIOD.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelIOD.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelIOD.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelIOD.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelIOD.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelIOD.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelIOD.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelIOD.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelIOD.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelIOD.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelIOD.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelIOD.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelIOD.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelIOD.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelIOD.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelIOD.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelIOD.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelIOD.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelIOD.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelIOD.ncl

ncl plotSingleModelIOD.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelIOD.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelIOD.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelIOD.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelIOD.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelIOD.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelIOD.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelIOD.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelIOD.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelIOD.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelIOD.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelIOD.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelIOD.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelIOD.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelIOD.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelIOD.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelIOD.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelIOD.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelIOD.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelIOD.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelIOD.ncl

ncl plotAvgModelIOD.ncl

#########
#8. Plot for SIOD predictor but only when significant
########
prdctor='"SIOD"'

cp ./templateIndividualProb.ncl ./plotSingleModelSIOD.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelSIOD.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelSIOD.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelSIOD.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelSIOD.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelSIOD.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelSIOD.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelSIOD.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelSIOD.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelSIOD.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelSIOD.ncl     
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelSIOD.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelSIOD.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelSIOD.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelSIOD.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelSIOD.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelSIOD.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelSIOD.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelSIOD.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelSIOD.ncl

ncl plotSingleModelSIOD.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelSIOD.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelSIOD.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelSIOD.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelSIOD.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelSIOD.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelSIOD.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelSIOD.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelSIOD.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelSIOD.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelSIOD.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelSIOD.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelSIOD.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelSIOD.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelSIOD.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelSIOD.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelSIOD.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelSIOD.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelSIOD.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelSIOD.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelSIOD.ncl

ncl plotAvgModelSIOD.ncl

#########
#9. Plot for PC1 predictor but only when significant
########
prdctor='"PC1"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC1.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelPC1.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC1.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC1.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelPC1.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC1.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC1.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelPC1.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelPC1.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelPC1.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelPC1.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC1.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC1.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelPC1.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelPC1.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC1.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelPC1.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelPC1.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelPC1.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelPC1.ncl

ncl plotSingleModelPC1.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC1.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelPC1.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC1.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC1.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelPC1.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC1.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC1.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelPC1.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelPC1.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelPC1.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelPC1.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC1.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC1.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelPC1.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelPC1.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC1.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelPC1.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelPC1.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelPC1.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelPC1.ncl

ncl plotAvgModelPC1.ncl

#########
#10. Plot for PC1 predictor but only when significant
########
prdctor='"PC2"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC2.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelPC2.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC2.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC2.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelPC2.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC2.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC2.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelPC2.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelPC2.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelPC2.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelPC2.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC2.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC2.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ././plotSingleModelPC2.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelPC2.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC2.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelPC2.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelPC2.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelPC2.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelPC2.ncl

ncl plotSingleModelPC2.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC2.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelPC2.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC2.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC2.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelPC2.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC2.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC2.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelPC2.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelPC2.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelPC2.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelPC2.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC2.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC2.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelPC2.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelPC2.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC2.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelPC2.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelPC2.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelPC2.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelPC2.ncl

ncl plotAvgModelPC2.ncl

#########
#11. Plot for PC3 predictor but only when significant
########
prdctor='"PC3"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC3.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelPC3.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC3.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC3.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelPC3.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC3.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC3.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelPC3.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelPC3.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelPC3.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelPC3.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC3.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC3.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelPC3.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelPC3.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC3.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelPC3.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelPC3.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelPC3.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelPC3.ncl

ncl plotSingleModelPC3.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC3.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelPC3.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC3.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC3.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelPC3.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC3.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC3.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelPC3.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelPC3.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelPC3.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelPC3.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC3.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC3.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelPC3.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelPC3.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC3.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelPC3.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelPC3.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelPC3.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelPC3.ncl

ncl plotAvgModelPC3.ncl

###########
#12. Plot for PC4 predictor but only when significant
########
prdctor='"PC4"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC4.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelPC4.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC4.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC4.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelPC4.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC4.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC4.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelPC4.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelPC4.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelPC4.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelPC4.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC4.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC4.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelPC4.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelPC4.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC4.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelPC4.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelPC4.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelPC4.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelPC4.ncl

ncl plotSingleModelPC4.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC4.ncl


sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelPC4.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC4.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC4.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelPC4.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC4.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC4.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelPC4.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelPC4.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelPC4.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelPC4.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC4.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC4.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelPC4.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelPC4.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC4.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelPC4.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelPC4.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelPC4.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelPC4.ncl

ncl plotAvgModelPC4.ncl

###########
#13. Plot for PC5 predictor but only when significant
########
prdctor='"PC5"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC5.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelPC5.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC5.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC5.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelPC5.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC5.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC5.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelPC5.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelPC5.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelPC5.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelPC5.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC5.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC5.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelPC5.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelPC5.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC5.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelPC5.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelPC5.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelPC5.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelPC5.ncl

ncl plotSingleModelPC5.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC5.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelPC5.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC5.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC5.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelPC5.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC5.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC5.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelPC5.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelPC5.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelPC5.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelPC5.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC5.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC5.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelPC5.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelPC5.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC5.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelPC5.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelPC5.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelPC5.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelPC5.ncl

ncl plotAvgModelPC5.ncl

###########
#14. Plot for PC6 predictor but only when significant
########
prdctor='"PC6"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC6.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSingleModelPC6.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC6.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC6.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSingleModelPC6.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC6.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC6.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSingleModelPC6.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSingleModelPC6.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSingleModelPC6.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSingleModelPC6.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC6.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC6.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSingleModelPC6.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSingleModelPC6.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC6.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSingleModelPC6.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSingleModelPC6.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSingleModelPC6.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSingleModelPC6.ncl

ncl plotSingleModelPC6.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC6.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgModelPC6.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC6.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC6.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgModelPC6.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC6.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC6.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgModelPC6.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgModelPC6.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgModelPC6.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgModelPC6.ncl
sed -i '' -E "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC6.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC6.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgModelPC6.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgModelPC6.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC6.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgModelPC6.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgModelPC6.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgModelPC6.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgModelPC6.ncl

ncl plotAvgModelPC6.ncl

###########
#15 Plot skill weighted Ens and their average over all predictors
########
cp ./templateEnsSkill.ncl ./plotSkillWtdAvg.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotSkillWtdAvg.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotSkillWtdAvg.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotSkillWtdAvg.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotSkillWtdAvg.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotSkillWtdAvg.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotSkillWtdAvg.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotSkillWtdAvg.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotSkillWtdAvg.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotSkillWtdAvg.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotSkillWtdAvg.ncl
sed -i '' -E "20s|ALLPRDCT|$allprdctor|" ./plotSkillWtdAvg.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotSkillWtdAvg.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotSkillWtdAvg.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotSkillWtdAvg.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotSkillWtdAvg.ncl  
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotSkillWtdAvg.ncl  
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotSkillWtdAvg.ncl  
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotSkillWtdAvg.ncl  
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotSkillWtdAvg.ncl  

ncl plotSkillWtdAvg.ncl

#### Plot all predictors average Max and Average skill for all models
cp ./templateSingleAvgPrdctors.ncl plotAvgPrdctorsSkill.ncl

sed -i '' -E "10s|ILEAD|$ilead|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "11s|SZNLENLGIC|$szn4mon|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "12s|LOGICSTATE|$isstate|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "13s|OMONS|$startmon|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "14s|CURRENTYR|$currentyr|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "15s|SEASONNAME|$seasonname|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "16s|LATS|$latS|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "17s|LATN|$latN|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "18s|LONW|$lonW|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "19s|LONE|$lonE|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "20s|ALLPRDCT|$allprdctor|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "21s|MYCOUNTRY|$mycountry|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "22s|OBSRES|$obsres|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "23s|PRINTPROB|$printProb|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "25s|TESTLATS|$tlats|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "26s|TESTLATN|$tlatn|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "27s|TESTLONW|$tlonw|" ./plotAvgPrdctorsSkill.ncl
sed -i '' -E "28s|TESTLONE|$tlone|" ./plotAvgPrdctorsSkill.ncl

ncl plotAvgPrdctorsSkill.ncl

else


#####
#2 Get observational validation data
#####
cp ./templateObs.ncl obsPrecip.ncl
sed -i "9s|OBSMONS|$obsstartmon|" ./obsPrecip.ncl 
sed -i "10s|OBSMONE|$obsendmon|" ./obsPrecip.ncl 
sed -i "11s|OBSDAYE|$obsendday|" ./obsPrecip.ncl 
sed -i "12s|SEASONNAME|$seasonname|" ./obsPrecip.ncl
sed -i "13s|FIRSTYR|$firstyr|" ./obsPrecip.ncl 
sed -i "14s|LASTYR|$currentyr|" ./obsPrecip.ncl 
sed -i "15s|LATS|$latS|" ./obsPrecip.ncl 
sed -i "16s|LATN|$latN|" ./obsPrecip.ncl 
sed -i "17s|LONW|$lonW|" ./obsPrecip.ncl 
sed -i "18s|LONE|$lonE|" ./obsPrecip.ncl 
sed -i "19s|OBST|$obst|" ./obsPrecip.ncl 
sed -i "20s|MONTHLY|$monthly|" ./obsPrecip.ncl
sed -i "21s|OBSRES|$obsres|" ./obsPrecip.ncl

ncl obsPrecip.ncl

######################
#3. Get Model predicted SST 
######################
cp ./template1LeadSSTDownloadStdz.ncl sstDownloadStdz.ncl

sed -i "5s|OMONS|$startmon|" ./sstDownloadStdz.ncl
sed -i "6s|CURRENTYR|$currentyr|" ./sstDownloadStdz.ncl
sed -i "7s|SEASONNAME|$seasonname|" ./sstDownloadStdz.ncl
sed -i "8s|FIRSTYR|$firstyr|" ./sstDownloadStdz.ncl
sed -i "9s|LASTYR|$endyr|" ./sstDownloadStdz.ncl
sed -i "10s|LEADI|$leadi|" ./sstDownloadStdz.ncl
sed -i "11s|LEADF|$leadf|" ./sstDownloadStdz.ncl

sed -i "13s|LonWEOF|$lonWeof|" ./sstDownloadStdz.ncl
sed -i "14s|LonEEOF|$lonEeof|" ./sstDownloadStdz.ncl
sed -i "15s|LatSEOF|$latSeof|" ./sstDownloadStdz.ncl
sed -i "16s|LatNEOF|$latNeof|" ./sstDownloadStdz.ncl

sed -i "18s|NUMEOF|$numeof|" ./sstDownloadStdz.ncl
sed -i "19s|CLIMYRS|$yrsstsc|" ./sstDownloadStdz.ncl
sed -i "20s|CLIMYRE|$yrsstec|" ./sstDownloadStdz.ncl

ncl sstDownloadStdz.ncl

#####################
#4. Run the Rscript to do tge logistic regression
##############
cp ./templateSST1LeadDriver.R  multiNominalRegression.R

sed -i "30s|OMONS|$startmon|" ./multiNominalRegression.R
sed -i "31s|SZNLEN|$sznlen|" ./multiNominalRegression.R
sed -i "32s|CURRENTYR|$currentyr|" ./multiNominalRegression.R
sed -i "33s|SEASONNAME|$seasonname|" ./multiNominalRegression.R
sed -i "34s|OBSPRECIP|$obsprecip|" ./multiNominalRegression.R
sed -i "35s|FIRSTYR|$firstyr|" ./multiNominalRegression.R
sed -i "36s|LASTYR|$endyr|" ./multiNominalRegression.R
sed -i "37s|ILEAD|$ilead|" ./multiNominalRegression.R
sed -i "38s|TRAINLEN|$trainLength|" ./multiNominalRegression.R
sed -i "39s|NPRDFIRST|$nprdFirst|" ./multiNominalRegression.R

Rscript multiNominalRegression.R 

#########
#5. Plot for Nino34 predictor without checking significance 
########
prdctor='"Nino34"'

cp ./templateIndividualProb.ncl ./plotSingleModelN34.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelN34.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelN34.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelN34.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelN34.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelN34.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelN34.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelN34.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelN34.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelN34.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelN34.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelN34.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelN34.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelN34.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelN34.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelN34.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelN34.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelN34.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelN34.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelN34.ncl

ncl plotSingleModelN34.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelN34.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelN34.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelN34.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelN34.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelN34.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelN34.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelN34.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelN34.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelN34.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelN34.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelN34.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelN34.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelN34.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelN34.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelN34.ncl  
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelN34.ncl  
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelN34.ncl  
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelN34.ncl  
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelN34.ncl  
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelN34.ncl  

ncl plotAvgModelN34.ncl

#########
#6. Plot for WVG but only when significant  
########
prdctor='"WVG"'

cp ./templateIndividualProb.ncl ./plotSingleModelWVG.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelWVG.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelWVG.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelWVG.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelWVG.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelWVG.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelWVG.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelWVG.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelWVG.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelWVG.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelWVG.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelWVG.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelWVG.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelWVG.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelWVG.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelWVG.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelWVG.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelWVG.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelWVG.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelWVG.ncl

ncl plotSingleModelWVG.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelWVG.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelWVG.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelWVG.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelWVG.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelWVG.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelWVG.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelWVG.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelWVG.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelWVG.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelWVG.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelWVG.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelWVG.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelWVG.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelWVG.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelWVG.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelWVG.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelWVG.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelWVG.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelWVG.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelWVG.ncl

ncl plotAvgModelWVG.ncl

#########
#7. Plot for IOD predictor without checking significance 
########
prdctor='"IOD"'

cp ./templateIndividualProb.ncl ./plotSingleModelIOD.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelIOD.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelIOD.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelIOD.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelIOD.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelIOD.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelIOD.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelIOD.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelIOD.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelIOD.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelIOD.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelIOD.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelIOD.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelIOD.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelIOD.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelIOD.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelIOD.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelIOD.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelIOD.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelIOD.ncl

ncl plotSingleModelIOD.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelIOD.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelIOD.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelIOD.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelIOD.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelIOD.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelIOD.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelIOD.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelIOD.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelIOD.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelIOD.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelIOD.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelIOD.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelIOD.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelIOD.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelIOD.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelIOD.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelIOD.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelIOD.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelIOD.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelIOD.ncl

ncl plotAvgModelIOD.ncl

#########
#8. Plot for SIOD predictor but only when significant
########
prdctor='"SIOD"'

cp ./templateIndividualProb.ncl ./plotSingleModelSIOD.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelSIOD.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelSIOD.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelSIOD.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelSIOD.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelSIOD.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelSIOD.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelSIOD.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelSIOD.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelSIOD.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelSIOD.ncl     
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelSIOD.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelSIOD.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelSIOD.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelSIOD.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelSIOD.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelSIOD.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelSIOD.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelSIOD.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelSIOD.ncl

ncl plotSingleModelSIOD.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelSIOD.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelSIOD.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelSIOD.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelSIOD.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelSIOD.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelSIOD.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelSIOD.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelSIOD.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelSIOD.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelSIOD.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelSIOD.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelSIOD.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelSIOD.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelSIOD.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelSIOD.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelSIOD.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelSIOD.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelSIOD.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelSIOD.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelSIOD.ncl

ncl plotAvgModelSIOD.ncl

#########
#9. Plot for PC1 predictor but only when significant
########
prdctor='"PC1"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC1.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelPC1.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC1.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC1.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelPC1.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC1.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC1.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelPC1.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelPC1.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelPC1.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelPC1.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC1.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC1.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelPC1.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelPC1.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC1.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelPC1.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelPC1.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelPC1.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelPC1.ncl

ncl plotSingleModelPC1.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC1.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelPC1.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC1.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC1.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelPC1.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC1.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC1.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelPC1.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelPC1.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelPC1.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelPC1.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC1.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC1.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelPC1.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelPC1.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC1.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelPC1.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelPC1.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelPC1.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelPC1.ncl

ncl plotAvgModelPC1.ncl

#########
#10. Plot for PC1 predictor but only when significant
########
prdctor='"PC2"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC2.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelPC2.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC2.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC2.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelPC2.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC2.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC2.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelPC2.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelPC2.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelPC2.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelPC2.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC2.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC2.ncl
sed -i "22s|OBSRES|$obsres|" ././plotSingleModelPC2.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelPC2.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC2.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelPC2.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelPC2.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelPC2.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelPC2.ncl

ncl plotSingleModelPC2.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC2.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelPC2.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC2.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC2.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelPC2.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC2.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC2.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelPC2.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelPC2.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelPC2.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelPC2.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC2.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC2.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelPC2.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelPC2.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC2.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelPC2.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelPC2.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelPC2.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelPC2.ncl

ncl plotAvgModelPC2.ncl

#########
#11. Plot for PC3 predictor but only when significant
########
prdctor='"PC3"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC3.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelPC3.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC3.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC3.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelPC3.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC3.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC3.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelPC3.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelPC3.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelPC3.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelPC3.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC3.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC3.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelPC3.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelPC3.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC3.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelPC3.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelPC3.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelPC3.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelPC3.ncl

ncl plotSingleModelPC3.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC3.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelPC3.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC3.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC3.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelPC3.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC3.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC3.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelPC3.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelPC3.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelPC3.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelPC3.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC3.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC3.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelPC3.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelPC3.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC3.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelPC3.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelPC3.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelPC3.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelPC3.ncl

ncl plotAvgModelPC3.ncl

###########
#12. Plot for PC4 predictor but only when significant
########
prdctor='"PC4"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC4.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelPC4.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC4.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC4.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelPC4.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC4.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC4.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelPC4.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelPC4.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelPC4.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelPC4.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC4.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC4.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelPC4.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelPC4.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC4.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelPC4.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelPC4.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelPC4.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelPC4.ncl

ncl plotSingleModelPC4.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC4.ncl


sed -i "10s|ILEAD|$ilead|" ./plotAvgModelPC4.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC4.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC4.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelPC4.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC4.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC4.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelPC4.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelPC4.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelPC4.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelPC4.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC4.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC4.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelPC4.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelPC4.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC4.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelPC4.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelPC4.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelPC4.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelPC4.ncl

ncl plotAvgModelPC4.ncl

###########
#13. Plot for PC5 predictor but only when significant
########
prdctor='"PC5"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC5.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelPC5.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC5.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC5.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelPC5.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC5.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC5.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelPC5.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelPC5.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelPC5.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelPC5.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC5.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC5.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelPC5.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelPC5.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC5.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelPC5.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelPC5.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelPC5.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelPC5.ncl

ncl plotSingleModelPC5.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC5.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelPC5.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC5.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC5.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelPC5.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC5.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC5.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelPC5.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelPC5.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelPC5.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelPC5.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC5.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC5.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelPC5.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelPC5.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC5.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelPC5.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelPC5.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelPC5.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelPC5.ncl

ncl plotAvgModelPC5.ncl

###########
#14. Plot for PC6 predictor but only when significant
########
prdctor='"PC6"'

cp ./templateIndividualProb.ncl ./plotSingleModelPC6.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSingleModelPC6.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSingleModelPC6.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSingleModelPC6.ncl
sed -i "13s|OMONS|$startmon|" ./plotSingleModelPC6.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSingleModelPC6.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSingleModelPC6.ncl
sed -i "16s|LATS|$latS|" ./plotSingleModelPC6.ncl
sed -i "17s|LATN|$latN|" ./plotSingleModelPC6.ncl
sed -i "18s|LONW|$lonW|" ./plotSingleModelPC6.ncl
sed -i "19s|LONE|$lonE|" ./plotSingleModelPC6.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotSingleModelPC6.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSingleModelPC6.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSingleModelPC6.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSingleModelPC6.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSingleModelPC6.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotSingleModelPC6.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotSingleModelPC6.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotSingleModelPC6.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotSingleModelPC6.ncl

ncl plotSingleModelPC6.ncl

##### Plot for the ensemble
cp ./templateEnsProb.ncl ./plotAvgModelPC6.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgModelPC6.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgModelPC6.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgModelPC6.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgModelPC6.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgModelPC6.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgModelPC6.ncl
sed -i "16s|LATS|$latS|" ./plotAvgModelPC6.ncl
sed -i "17s|LATN|$latN|" ./plotAvgModelPC6.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgModelPC6.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgModelPC6.ncl
sed -i "20s|SLCTDPRD|$prdctor|" ./plotAvgModelPC6.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgModelPC6.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgModelPC6.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgModelPC6.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgModelPC6.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgModelPC6.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgModelPC6.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgModelPC6.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgModelPC6.ncl

ncl plotAvgModelPC6.ncl

###########
#15 Plot skill weighted Ens and their average over all predictors
########
cp ./templateEnsSkill.ncl ./plotSkillWtdAvg.ncl

sed -i "10s|ILEAD|$ilead|" ./plotSkillWtdAvg.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotSkillWtdAvg.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotSkillWtdAvg.ncl
sed -i "13s|OMONS|$startmon|" ./plotSkillWtdAvg.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotSkillWtdAvg.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotSkillWtdAvg.ncl
sed -i "16s|LATS|$latS|" ./plotSkillWtdAvg.ncl
sed -i "17s|LATN|$latN|" ./plotSkillWtdAvg.ncl
sed -i "18s|LONW|$lonW|" ./plotSkillWtdAvg.ncl
sed -i "19s|LONE|$lonE|" ./plotSkillWtdAvg.ncl
sed -i "20s|ALLPRDCT|$allprdctor|" ./plotSkillWtdAvg.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotSkillWtdAvg.ncl
sed -i "22s|OBSRES|$obsres|" ./plotSkillWtdAvg.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotSkillWtdAvg.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotSkillWtdAvg.ncl  
sed -i "25s|TESTLATS|$tlats|" ./plotSkillWtdAvg.ncl  
sed -i "26s|TESTLATN|$tlatn|" ./plotSkillWtdAvg.ncl  
sed -i "27s|TESTLONW|$tlonw|" ./plotSkillWtdAvg.ncl  
sed -i "28s|TESTLONE|$tlone|" ./plotSkillWtdAvg.ncl  

ncl plotSkillWtdAvg.ncl


#### Plot all predictors average Max and Average skill for all models
cp ./templateSingleAvgPrdctors.ncl plotAvgPrdctorsSkill.ncl

sed -i "10s|ILEAD|$ilead|" ./plotAvgPrdctorsSkill.ncl
sed -i "11s|SZNLENLGIC|$szn4mon|" ./plotAvgPrdctorsSkill.ncl
sed -i "12s|LOGICSTATE|$isstate|" ./plotAvgPrdctorsSkill.ncl
sed -i "13s|OMONS|$startmon|" ./plotAvgPrdctorsSkill.ncl
sed -i "14s|CURRENTYR|$currentyr|" ./plotAvgPrdctorsSkill.ncl
sed -i "15s|SEASONNAME|$seasonname|" ./plotAvgPrdctorsSkill.ncl
sed -i "16s|LATS|$latS|" ./plotAvgPrdctorsSkill.ncl
sed -i "17s|LATN|$latN|" ./plotAvgPrdctorsSkill.ncl
sed -i "18s|LONW|$lonW|" ./plotAvgPrdctorsSkill.ncl
sed -i "19s|LONE|$lonE|" ./plotAvgPrdctorsSkill.ncl
sed -i "20s|ALLPRDCT|$allprdctor|" ./plotAvgPrdctorsSkill.ncl
sed -i "21s|MYCOUNTRY|$mycountry|" ./plotAvgPrdctorsSkill.ncl
sed -i "22s|OBSRES|$obsres|" ./plotAvgPrdctorsSkill.ncl
sed -i "23s|PRINTPROB|$printProb|" ./plotAvgPrdctorsSkill.ncl
sed -i "24s|PRINTPROBRAW|$printProbRaw|" ./plotAvgPrdctorsSkill.ncl
sed -i "25s|TESTLATS|$tlats|" ./plotAvgPrdctorsSkill.ncl
sed -i "26s|TESTLATN|$tlatn|" ./plotAvgPrdctorsSkill.ncl
sed -i "27s|TESTLONW|$tlonw|" ./plotAvgPrdctorsSkill.ncl
sed -i "28s|TESTLONE|$tlone|" ./plotAvgPrdctorsSkill.ncl

ncl plotAvgPrdctorsSkill.ncl

fi

echo `date`
