begin
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Define Colors 

 tempKlevels    = (/278, 280, 282, 284, 286,  \
                    288, 290, 292, 294, 296, \
                    298, 300, 302, 304, 306, \
                    308, 310, 312, 314       /)

tempClevels     = (/ 4, 6,  8, 10, 12,  \
                   14, 16, 18, 20, 22, \
                   24, 26, 28, 30, 32, \
                   34, 36, 38, 40 /)

 tempcolors = read_colormap_file("temp_19lev")

 colorsunshine = read_colormap_file("sunshine_9lev")

;;;; Create anomay color from blue to white to yellow to red
  x = (/"blue","white" /)
  opt                  = True
  opt@NumColorsInRange = (/ 11/)
  yb = span_named_colors(x,opt)
  yblue = yb(2::,:)

  x = (/"lightyellow","yellow" /)
  opt                  = True
  opt@NumColorsInRange = (/ 8/)
  yy1 = span_named_colors(x,opt)
  yy2 = yy1(2::,:)
  yyellow = yy2(1:2,:)

  x = (/"yellow","red" /)
  opt                  = True
  opt@NumColorsInRange = (/ 10/)
  yr1 = span_named_colors(x,opt)
  yyellow(1,:) = yr1(3,:)
  yred = yr1(4::,:)

  dim = dimsizes(yblue)
  y1d = dim(0)
  dim = dimsizes(yyellow)
  y2d = dim(0)
  dim = dimsizes(yred)
  y3d =  dim(0)
  y = y1d+y2d+y3d
  coloranomaly = new((/y,dim(1)/),typeof(yblue))
  coloranomaly(0:y1d-1,:) = yblue
  coloranomaly(y1d:(y1d+y2d-1),:) = yyellow
  coloranomaly(y1d+y2d:y-1,:) = yred

  delete([/yb,yy1,yy2,yr1,y1d,y2d,y3d,dim,yblue,yred,x,opt,y,y1d,y2d/])

;;;;;;;;;;
;;;;
   opt  = True
   opt@fout  = "colAnomalyTT2mWRF.txt"
   fmtx   = "3(f7.5,1x) "
   write_matrix(coloranomaly,fmtx,opt)
   
end

